/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.function.Supplier;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class BasicDateHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private ZonedDateTime parsed;

    public static BasicDateHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicDateHeader(name, value);
    }

    public static BasicDateHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicDateHeader(name, value);
    }

    public BasicDateHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(this.getParsedValue());
    }

    public Calendar asCalendar() {
        ZonedDateTime zdt = this.getParsedValue();
        return zdt == null ? null : GregorianCalendar.from(zdt);
    }

    public Date asDate() {
        Calendar c = this.asCalendar();
        return c == null ? null : c.getTime();
    }

    public ZonedDateTime asZonedDateTime() {
        return this.getParsedValue();
    }

    public FluentZonedDateTimeAssertion<BasicDateHeader> assertZonedDateTime() {
        return new FluentZonedDateTimeAssertion<BasicDateHeader>(this.asZonedDateTime(), this);
    }

    private ZonedDateTime getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        if (o instanceof ZonedDateTime) {
            return ((ZonedDateTime)o).truncatedTo(ChronoUnit.SECONDS);
        }
        if (o instanceof GregorianCalendar) {
            return ((GregorianCalendar)o).toZonedDateTime().truncatedTo(ChronoUnit.SECONDS);
        }
        return ZonedDateTime.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(o.toString())).truncatedTo(ChronoUnit.SECONDS);
    }
}

