/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.PathAnnotation;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.util.UrlPathMatcher;

public class PathArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;
    private final String name;
    private final String def;
    private final Type type;

    public static PathArg create(ParameterInfo paramInfo, AnnotationWorkList annotations, UrlPathMatcher pathMatcher) {
        if (AP.has(Path.class, paramInfo, new AnnotationTraversal[0])) {
            return new PathArg(paramInfo, annotations, pathMatcher);
        }
        return null;
    }

    private static Path getMergedPath(ParameterInfo pi, String paramName) {
        ClassInfo declaringClass = pi.getMethod().getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        Rest restAnnotation = declaringClass.getAnnotations(Rest.class).findFirst().map(AnnotationInfo::inner).orElse(null);
        if (restAnnotation == null) {
            return null;
        }
        Path classLevelPath = null;
        for (Path p : restAnnotation.pathParams()) {
            String pName = StringUtils.firstNonEmpty(p.name(), p.value());
            if (!paramName.equals(pName)) continue;
            classLevelPath = p;
            break;
        }
        if (classLevelPath == null) {
            return null;
        }
        Path paramPath = AP.find(Path.class, pi, new AnnotationTraversal[0]).stream().findFirst().map(AnnotationInfo::inner).orElse(null);
        if (paramPath == null) {
            return classLevelPath;
        }
        return PathArg.mergeAnnotations(classLevelPath, paramPath);
    }

    private static Path mergeAnnotations(Path classLevel, Path paramLevel) {
        return PathAnnotation.create().name(StringUtils.firstNonEmpty(paramLevel.name(), paramLevel.value(), classLevel.name(), classLevel.value())).value(StringUtils.firstNonEmpty(paramLevel.value(), paramLevel.name(), classLevel.value(), classLevel.name())).def(StringUtils.firstNonEmpty(paramLevel.def(), classLevel.def())).description(paramLevel.description().length > 0 ? paramLevel.description() : classLevel.description()).parser(paramLevel.parser() != HttpPartParser.Void.class ? paramLevel.parser() : classLevel.parser()).serializer(paramLevel.serializer() != HttpPartSerializer.Void.class ? paramLevel.serializer() : classLevel.serializer()).schema(PathArg.mergeSchemas(classLevel.schema(), paramLevel.schema())).build();
    }

    private static Schema mergeSchemas(Schema classLevel, Schema paramLevel) {
        if (!SchemaAnnotation.empty(paramLevel)) {
            return paramLevel;
        }
        return classLevel;
    }

    protected PathArg(ParameterInfo paramInfo, AnnotationWorkList annotations, UrlPathMatcher pathMatcher) {
        this.name = PathArg.getName(paramInfo, pathMatcher);
        Path mergedPath = PathArg.getMergedPath(paramInfo, this.name);
        String pathDef = Utils.nn(mergedPath) ? mergedPath.def() : null;
        this.def = Utils.nn(pathDef) && Utils.neq("_NONE_", pathDef) ? pathDef : (String)PathAnnotation.findDef(paramInfo).orElse(null);
        this.type = paramInfo.getParameterType().innerType();
        this.schema = Utils.nn(mergedPath) ? HttpPartSchema.create(mergedPath) : HttpPartSchema.create(Path.class, paramInfo);
        Class<? extends HttpPartParser> pp = this.schema.getParser();
        this.partParser = Utils.nn(pp) ? (HttpPartParser)HttpPartParser.creator().type((Class)pp).apply(annotations).create() : null;
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        if (this.name.equals("*")) {
            JsonMap m = new JsonMap();
            req.getPathParams().stream().forEach(x -> m.put(x.getName(), (Object)x.getValue()));
            return req.getBeanSession().convertToType(m, this.type, new Type[0]);
        }
        HttpPartParserSession ps = this.partParser == null ? req.getPartParserSession() : this.partParser.getPartSession();
        return req.getPathParams().get(this.name).parser(ps).schema(this.schema).def(this.def).as(this.type, new Type[0]).orElse(null);
    }

    private static String getName(ParameterInfo pi, UrlPathMatcher pathMatcher) {
        String p = PathAnnotation.findName(pi).orElse(null);
        if (Utils.nn(p)) {
            return p;
        }
        if (Utils.nn(pathMatcher)) {
            int idx = 0;
            int i = pi.getIndex();
            MethodInfo mi = pi.getMethod();
            for (int j = 0; j < i; ++j) {
                boolean hasAnnotation = AP.has(Path.class, mi.getParameter(j), new AnnotationTraversal[0]);
                if (!hasAnnotation) continue;
                ++idx;
            }
            String[] vars = pathMatcher.getVars();
            if (vars.length <= idx) {
                throw new ArgException(pi, "Number of attribute parameters exceeds the number of URL pattern variables.  vars.length={0}, idx={1}", vars.length, idx);
            }
            String idxs = String.valueOf(idx);
            for (String var : vars) {
                if (!StringUtils.isNumeric(var) || !var.equals(idxs)) continue;
                return var;
            }
            return pathMatcher.getVars()[idx];
        }
        throw new ArgException(pi, "@Path used without name or value", new Object[0]);
    }
}

