/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.EventListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;

public abstract class ListenerHandler
implements Comparable<ListenerHandler> {
    private final long contextServiceId;
    private final ListenerInfo listenerInfo;
    private final ExtServletContext context;
    private EventListener listener;
    protected volatile int useCount;

    public ListenerHandler(long contextServiceId, ExtServletContext context, ListenerInfo listenerInfo) {
        this.contextServiceId = contextServiceId;
        this.context = context;
        this.listenerInfo = listenerInfo;
    }

    @Override
    public int compareTo(ListenerHandler other) {
        return this.listenerInfo.compareTo(other.listenerInfo);
    }

    public ExtServletContext getContext() {
        return this.context;
    }

    public long getContextServiceId() {
        return this.contextServiceId;
    }

    public EventListener getListener() {
        return this.listener;
    }

    protected void setListener(EventListener f) {
        this.listener = f;
    }

    public ListenerInfo getListenerInfo() {
        return this.listenerInfo;
    }

    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        if (this.listener == null) {
            return 5;
        }
        ++this.useCount;
        return -1;
    }

    public boolean destroy() {
        if (this.listener == null) {
            return false;
        }
        --this.useCount;
        if (this.useCount == 0) {
            this.listener = null;
            return true;
        }
        return false;
    }

    public boolean dispose() {
        this.useCount = 1;
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.listenerInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerHandler other = (ListenerHandler)obj;
        return this.listenerInfo.equals(other.listenerInfo);
    }
}

