/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.linkedin2;

import java.net.URI;
import java.util.List;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Location;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Position;

public class LinkedIn2Profile
extends OAuth20Profile {
    private static final long serialVersionUID = -2652388591255880018L;

    public String getOAuth10Id() {
        String url = this.getSiteStandardProfileRequest();
        return CommonHelper.substringBetween((String)url, (String)"id=", (String)"&authType=");
    }

    public String getFirstName() {
        return (String)this.getAttribute("firstName");
    }

    public String getFamilyName() {
        return (String)this.getAttribute("lastName");
    }

    public String getDisplayName() {
        return (String)this.getAttribute("formattedName");
    }

    public String getLocation() {
        LinkedIn2Location location = (LinkedIn2Location)this.getAttribute("location");
        if (location != null) {
            return location.getName();
        }
        return null;
    }

    public String getEmail() {
        return (String)this.getAttribute("emailAddress");
    }

    public URI getPictureUrl() {
        return (URI)this.getAttribute("pictureUrl");
    }

    public URI getProfileUrl() {
        return (URI)this.getAttribute("publicProfileUrl");
    }

    public LinkedIn2Location getCompleteLocation() {
        return (LinkedIn2Location)this.getAttribute("location");
    }

    public String getMaidenName() {
        return (String)this.getAttribute("maidenName");
    }

    public String getPhoneticFirstName() {
        return (String)this.getAttribute("phoneticFirstName");
    }

    public String getPhoneticLastName() {
        return (String)this.getAttribute("phoneticLastName");
    }

    public String getFormattedPhoneticName() {
        return (String)this.getAttribute("formattedPhoneticName");
    }

    public String getHeadline() {
        return (String)this.getAttribute("headline");
    }

    public String getIndustry() {
        return (String)this.getAttribute("industry");
    }

    public String getCurrentShare() {
        return (String)this.getAttribute("currentShare");
    }

    public Integer getNumConnections() {
        return (Integer)this.getAttribute("numConnections");
    }

    public Boolean getNumConnectionsCapped() {
        return (Boolean)this.getAttribute("numConnectionsCapped");
    }

    public String getSummary() {
        return (String)this.getAttribute("summary");
    }

    public String getSpecialties() {
        return (String)this.getAttribute("specialties");
    }

    public List<LinkedIn2Position> getPositions() {
        return (List)this.getAttribute("positions");
    }

    public String getSiteStandardProfileRequest() {
        return (String)this.getAttribute("siteStandardProfileRequest");
    }

    public String getApiStandardProfileRequest() {
        return (String)this.getAttribute("apiStandardProfileRequest");
    }
}

