/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntrySerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(EntrySerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private transient SchemaManager schemaManager;

    public EntrySerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public byte[] serialize(Object object) throws IOException {
        Entry entry = (Entry)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        Dn dn = entry.getDn();
        if (dn.isEmpty()) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            Rdn rdn = dn.getRdn();
            rdn.writeExternal(out);
        }
        out.writeInt(entry.getAttributes().size());
        for (Attribute attribute : entry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            String oid = attributeType.getOid();
            out.writeUTF(oid);
            attribute.writeExternal(out);
        }
        out.flush();
        if (IS_DEBUG) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serialize " + entry);
        }
        return baos.toByteArray();
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            DefaultEntry entry = new DefaultEntry(this.schemaManager);
            byte hasDn = in.readByte();
            if (hasDn == 1) {
                Rdn rdn = new Rdn(this.schemaManager);
                rdn.readExternal(in);
                try {
                    entry.setDn(new Dn(this.schemaManager, rdn));
                }
                catch (LdapInvalidDnException lide) {
                    IOException ioe = new IOException(lide.getMessage());
                    ioe.initCause(lide);
                    throw ioe;
                }
            } else {
                entry.setDn(Dn.EMPTY_DN);
            }
            int nbAttributes = in.readInt();
            for (int i = 0; i < nbAttributes; ++i) {
                String oid = in.readUTF();
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                    DefaultAttribute attribute = new DefaultAttribute(attributeType);
                    attribute.readExternal(in);
                    entry.add(attribute);
                    continue;
                }
                catch (LdapException ne) {
                    throw new ClassNotFoundException(ne.getMessage(), ne);
                }
            }
            return entry;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err(I18n.ERR_134, cnfe.getLocalizedMessage()));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }
}

