/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import java.util.regex.Pattern;

public class HeaderName {
    private static final Pattern VALID = Pattern.compile("^[\\x21-\\x7e&&[^]\\[}{()<>@,;:\\\\\"/?=]]+$");
    public static final String ORIGIN = "Origin";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String VARY = "Vary";
    public static final String HOST = "Host";

    public static String formatCanonical(String name) {
        String nameTrimmed = name.trim();
        if (nameTrimmed.isEmpty()) {
            throw new IllegalArgumentException("The header field name must not be an empty string");
        }
        assert (VALID != null);
        if (!VALID.matcher(nameTrimmed).matches()) {
            throw new IllegalArgumentException("Invalid header field name syntax (see RFC 2616)");
        }
        String[] tokens = nameTrimmed.toLowerCase().split("-");
        String out = "";
        for (int i = 0; i < tokens.length; ++i) {
            char[] c = tokens[i].toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            if (i >= 1) {
                out = out + "-";
            }
            out = out + new String(c);
        }
        return out;
    }

    private HeaderName() {
    }
}

