/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.javabean;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.javabean.BeanProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class JavaBeanConverter
implements Converter {
    private ClassMapper classMapper;
    private String classAttributeIdentifier;
    private BeanProvider beanProvider;

    public JavaBeanConverter(ClassMapper classMapper, String classAttributeIdentifier) {
        this.classMapper = classMapper;
        this.classAttributeIdentifier = classAttributeIdentifier;
        this.beanProvider = new BeanProvider();
    }

    public boolean canConvert(Class type) {
        return this.beanProvider.canInstantiate(type);
    }

    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        this.beanProvider.visitSerializableProperties(source, new BeanProvider.Visitor(){

            public void visit(String propertyName, Class fieldType, Object newObj) {
                if (newObj != null) {
                    this.writeField(propertyName, fieldType, newObj);
                }
            }

            private void writeField(String propertyName, Class fieldType, Object newObj) {
                writer.startNode(JavaBeanConverter.this.classMapper.serializedMember(source.getClass(), propertyName));
                Class<?> actualType = newObj.getClass();
                Class defaultType = JavaBeanConverter.this.classMapper.defaultImplementationOf(fieldType);
                if (!actualType.equals(defaultType)) {
                    writer.addAttribute(JavaBeanConverter.this.classAttributeIdentifier, JavaBeanConverter.this.classMapper.serializedClass(actualType));
                }
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String propertyName = this.classMapper.realMember(result.getClass(), reader.getNodeName());
            boolean propertyExistsInClass = this.beanProvider.propertyDefinedInClass(propertyName, result.getClass());
            Class type = this.determineType(reader, result, propertyName);
            Object value = context.convertAnother(result, type);
            if (propertyExistsInClass) {
                this.beanProvider.writeProperty(result, propertyName, value);
            }
            reader.moveUp();
        }
        return result;
    }

    private Object instantiateNewInstance(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.beanProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    private Class determineType(HierarchicalStreamReader reader, Object result, String fieldName) {
        String classAttribute = reader.getAttribute(this.classAttributeIdentifier);
        if (classAttribute != null) {
            return this.classMapper.realClass(classAttribute);
        }
        return this.classMapper.defaultImplementationOf(this.beanProvider.getPropertyType(result, fieldName));
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }
}

