/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.impl.SolrClientCloudManager;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PREFERRED_LEADER_PROP = "property.preferredleader";
    public static final Set<String> SLICE_UNIQUE_BOOLEAN_PROPERTIES = ImmutableSet.of((Object)"property.preferredleader");
    protected final SolrCloudManager cloudManager;
    protected final DistribStateManager stateManager;
    protected final SolrZkClient zkClient;

    public SliceMutator(SolrCloudManager cloudManager) {
        this.cloudManager = cloudManager;
        this.stateManager = cloudManager.getDistribStateManager();
        this.zkClient = SliceMutator.getZkClient(cloudManager);
    }

    static SolrZkClient getZkClient(SolrCloudManager cloudManager) {
        if (cloudManager instanceof SolrClientCloudManager) {
            SolrClientCloudManager manager = (SolrClientCloudManager)cloudManager;
            return manager.getZkClient();
        }
        return null;
    }

    public ZkWriteCommand addReplica(ClusterState clusterState, ZkNodeProps message) {
        log.info("createReplica() {} ", (Object)message);
        String coll = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String slice = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(coll);
        Slice sl = collection.getSlice(slice);
        if (sl == null) {
            log.error("Invalid Collection/Slice {}/{} ", (Object)coll, (Object)slice);
            return ZkStateWriter.NO_OP;
        }
        String coreNodeName = message.getStr("core_node_name") != null ? message.getStr("core_node_name") : Assign.assignCoreNodeName(this.stateManager, collection);
        String nodeName = message.getStr("node_name");
        String baseUrl = Utils.getBaseUrlForNodeName((String)nodeName, (String)((String)this.cloudManager.getClusterStateProvider().getClusterProperty("urlScheme", (Object)"http")));
        Replica replica = new Replica(coreNodeName, Utils.makeMap((Object[])new Object[]{"core", message.getStr("core"), "state", message.getStr("state"), "node_name", nodeName, "base_url", baseUrl, "force_set_state", "false", "type", message.get("type")}), coll, slice);
        return new ZkWriteCommand(coll, SliceMutator.updateReplica(collection, sl, replica.getName(), replica));
    }

    public ZkWriteCommand removeReplica(ClusterState clusterState, ZkNodeProps message) {
        String cnn = message.getStr("core_node_name");
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollectionOrNull(collection);
        if (coll == null) {
            return new ZkWriteCommand(collection, null);
        }
        LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
        String nodeName = message.getStr("node_name");
        for (Slice slice : coll.getSlices()) {
            Replica replica = slice.getReplica(cnn);
            if (replica != null && (nodeName == null || nodeName.equals(replica.getNodeName()))) {
                Map newReplicas = slice.getReplicasCopy();
                newReplicas.remove(cnn);
                slice = new Slice(slice.getName(), newReplicas, slice.getProperties(), collection);
            }
            newSlices.put(slice.getName(), slice);
        }
        return new ZkWriteCommand(collection, coll.copyWithSlices(newSlices));
    }

    public ZkWriteCommand setShardLeader(ClusterState clusterState, ZkNodeProps message) {
        String leaderUrl = message.getStr("base_url") != null ? ZkCoreNodeProps.getCoreUrl((ZkNodeProps)message) : null;
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        DocCollection coll = clusterState.getCollectionOrNull(collectionName);
        if (coll == null) {
            log.error("Could not mark shard leader for non existing collection: {}", (Object)collectionName);
            return ZkStateWriter.NO_OP;
        }
        Map slices = coll.getSlicesMap();
        Slice slice = (Slice)slices.get(sliceName);
        Replica oldLeader = slice.getLeader();
        Replica newLeader = null;
        LinkedHashMap<String, Replica> newReplicas = new LinkedHashMap<String, Replica>();
        for (Replica replica : slice.getReplicas()) {
            String coreURL = ZkCoreNodeProps.getCoreUrl((String)replica.getBaseUrl(), (String)replica.getStr("core"));
            if (replica == oldLeader && !coreURL.equals(leaderUrl)) {
                replica = new ReplicaMutator(this.cloudManager).unsetLeader(replica);
            } else if (coreURL.equals(leaderUrl)) {
                newLeader = replica = new ReplicaMutator(this.cloudManager).setLeader(replica);
            }
            newReplicas.put(replica.getName(), replica);
        }
        Map newSliceProps = slice.shallowCopy();
        newSliceProps.put("replicas", newReplicas);
        slice = new Slice(slice.getName(), newReplicas, slice.getProperties(), collectionName);
        return new ZkWriteCommand(collectionName, CollectionMutator.updateSlice(collectionName, coll, slice));
    }

    public ZkWriteCommand updateShardState(ClusterState clusterState, ZkNodeProps message) {
        String collectionName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        log.info("Update shard state invoked for collection: {} with message: {}", (Object)collectionName, (Object)message);
        DocCollection collection = clusterState.getCollection(collectionName);
        LinkedHashMap<String, Slice> slicesCopy = new LinkedHashMap<String, Slice>(collection.getSlicesMap());
        for (String key : message.keySet()) {
            if ("collection".equals(key) || "operation".equals(key)) continue;
            Slice slice = collection.getSlice(key);
            if (slice == null) {
                throw new RuntimeException("Overseer.updateShardState unknown collection: " + collectionName + " slice: " + key);
            }
            if (log.isInfoEnabled()) {
                log.info("Update shard state {} to {}", (Object)key, (Object)message.getStr(key));
            }
            Map props = slice.shallowCopy();
            if (Slice.State.getState((String)message.getStr(key)) == Slice.State.ACTIVE) {
                props.remove("parent");
                props.remove("shard_parent_node");
                props.remove("shard_parent_zk_session");
            }
            props.put("state", message.getStr(key));
            props.put("stateTimestamp", String.valueOf(this.cloudManager.getTimeSource().getEpochTimeNs()));
            Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props, collectionName);
            slicesCopy.put(slice.getName(), newSlice);
        }
        return new ZkWriteCommand(collectionName, collection.copyWithSlices(slicesCopy));
    }

    public ZkWriteCommand addRoutingRule(ClusterState clusterState, ZkNodeProps message) {
        HashMap<String, String> map;
        RoutingRule r;
        String collectionName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String shard = message.getStr("shard");
        String routeKey = message.getStr("routeKey");
        String range = message.getStr("range");
        String targetCollection = message.getStr("targetCollection");
        String expireAt = message.getStr("expireAt");
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(shard);
        if (slice == null) {
            throw new RuntimeException("Overseer.addRoutingRule unknown collection: " + collectionName + " slice:" + shard);
        }
        HashMap<String, RoutingRule> routingRules = slice.getRoutingRules();
        if (routingRules == null) {
            routingRules = new HashMap<String, RoutingRule>();
        }
        if ((r = (RoutingRule)routingRules.get(routeKey)) == null) {
            map = new HashMap<String, String>();
            map.put("routeRanges", range);
            map.put("targetCollection", targetCollection);
            map.put("expireAt", expireAt);
            RoutingRule rule = new RoutingRule(routeKey, map);
            routingRules.put(routeKey, rule);
        } else {
            map = r.shallowCopy();
            map.put("routeRanges", map.get("routeRanges") + "," + range);
            map.put("expireAt", expireAt);
            routingRules.put(routeKey, new RoutingRule(routeKey, map));
        }
        Map props = slice.shallowCopy();
        props.put("routingRules", routingRules);
        Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props, collectionName);
        return new ZkWriteCommand(collectionName, CollectionMutator.updateSlice(collectionName, collection, newSlice));
    }

    public ZkWriteCommand removeRoutingRule(ClusterState clusterState, ZkNodeProps message) {
        String collectionName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String shard = message.getStr("shard");
        String routeKeyStr = message.getStr("routeKey");
        log.info("Overseer.removeRoutingRule invoked for collection: {} shard: {} routeKey: {}", new Object[]{collectionName, shard, routeKeyStr});
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(shard);
        if (slice == null) {
            log.warn("Unknown collection: {} shard: {}", (Object)collectionName, (Object)shard);
            return ZkStateWriter.NO_OP;
        }
        Map routingRules = slice.getRoutingRules();
        if (routingRules != null) {
            routingRules.remove(routeKeyStr);
            Map props = slice.shallowCopy();
            props.put("routingRules", routingRules);
            Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props, collectionName);
            return new ZkWriteCommand(collectionName, CollectionMutator.updateSlice(collectionName, collection, newSlice));
        }
        return ZkStateWriter.NO_OP;
    }

    public static DocCollection updateReplica(DocCollection collection, Slice slice, String coreNodeName, Replica replica) {
        Map replicasCopy = slice.getReplicasCopy();
        if (replica == null) {
            replicasCopy.remove(coreNodeName);
        } else {
            replicasCopy.put(replica.getName(), replica);
        }
        Slice newSlice = new Slice(slice.getName(), replicasCopy, slice.getProperties(), collection.getName());
        log.debug("Old Slice: {}", (Object)slice);
        log.debug("New Slice: {}", (Object)newSlice);
        return CollectionMutator.updateSlice(collection.getName(), collection, newSlice);
    }
}

