/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.rrd4j.core.RrdBackendException;
import org.rrd4j.core.RrdByteArrayBackend;

public class RrdBerkeleyDbBackend
extends RrdByteArrayBackend {
    private final Database rrdDatabase;

    protected RrdBerkeleyDbBackend(String path, Database rrdDatabase) {
        super(path);
        this.rrdDatabase = rrdDatabase;
    }

    protected RrdBerkeleyDbBackend(byte[] buffer, String path, Database rrdDatabase) {
        super(path);
        this.setBuffer(buffer);
        this.rrdDatabase = rrdDatabase;
    }

    @Override
    protected void close() throws IOException {
        if (this.isDirty()) {
            DatabaseEntry theKey = new DatabaseEntry(this.getPath().getBytes(StandardCharsets.UTF_8));
            DatabaseEntry theData = new DatabaseEntry(this.getBuffer());
            try {
                this.rrdDatabase.put(null, theKey, theData);
            }
            catch (DatabaseException de) {
                throw new RrdBackendException("failed to close the backend", de);
            }
        }
    }
}

