/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opensaml.ReplayCacheFactory;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLBrowserProfileFactory;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLIdentifierFactory;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;

public class POSTProfileTest
extends TestCase {
    private String path = "data/org/opensaml/test.jks";
    private String alias = "mykey";
    private char[] password = "opensaml".toCharArray();
    private KeyStore ks = null;

    public POSTProfileTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(POSTProfileTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Logger.getRootLogger().setLevel(Level.OFF);
        this.ks = KeyStore.getInstance("JKS");
        this.ks.load(new FileInputStream(this.path), this.password);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPOSTProfile() throws Exception {
        SAMLBrowserProfile profile = SAMLBrowserProfileFactory.getInstance();
        SAMLIdentifier idgen = SAMLIdentifierFactory.getInstance();
        SAMLResponse r = new SAMLResponse();
        SAMLAssertion a = new SAMLAssertion();
        SAMLAuthenticationStatement s = new SAMLAuthenticationStatement();
        SAMLSubject subject = new SAMLSubject(new SAMLNameIdentifier("foo", null, null), Collections.singleton("urn:oasis:names:tc:SAML:1.0:cm:bearer"), null, null);
        s.setSubject(subject);
        s.setAuthInstant(new Date());
        s.setAuthMethod("urn:oasis:names:tc:SAML:1.0:am:password");
        a.addStatement(s);
        a.setId(idgen.getIdentifier());
        a.setIssuer("http://www.opensaml.org");
        a.setNotBefore(new Date());
        a.setNotOnOrAfter(new Date(System.currentTimeMillis() + 60000L));
        a.addCondition(new SAMLAudienceRestrictionCondition(Collections.singleton("http://www.opensaml.org")));
        r.addAssertion(a);
        r.setId(idgen.getIdentifier());
        r.setRecipient("http://www.opensaml.org");
        r.toDOM();
        a.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", this.ks.getKey(this.alias, this.password), Arrays.asList(this.ks.getCertificateChain(this.alias)));
        r.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", this.ks.getKey(this.alias, this.password), Arrays.asList(this.ks.getCertificateChain(this.alias)));
        POSTProfileTest.assertTrue((String)"SAMLResponse is not signed.", (boolean)r.isSigned());
        r.verify(this.ks.getCertificate(this.alias));
        SAMLBrowserProfile.BrowserProfileRequest request = new SAMLBrowserProfile.BrowserProfileRequest();
        request.SAMLResponse = new String(r.toBase64());
        SAMLBrowserProfile.BrowserProfileResponse response = profile.receive(null, request, "http://www.opensaml.org", ReplayCacheFactory.getInstance(), null, 1);
        POSTProfileTest.assertTrue((String)"SAMLResponse is not signed.", (boolean)response.response.isSigned());
        response.assertion.verify(this.ks.getCertificate(this.alias));
        response.response.verify(this.ks.getCertificate(this.alias));
    }
}

