/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.NullCheckClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.jobs.DeleteDependency;
import org.apache.manifoldcf.crawler.system.Logging;

public class HopDeleteDeps
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: HopDeleteDeps.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String jobIDField = "jobid";
    public static final String ownerIDField = "ownerid";
    public static final String linkTypeField = "linktype";
    public static final String parentIDHashField = "parentidhash";
    public static final String childIDHashField = "childidhash";

    public HopDeleteDeps(IDBInterface database) throws ManifoldCFException {
        super(database, "hopdeletedeps");
    }

    public void install(String jobsTable, String jobsColumn, String hopCountTable, String idColumn) throws ManifoldCFException {
        block5: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(ownerIDField, new ColumnDescription("BIGINT", false, false, hopCountTable, idColumn, false));
                map.put(linkTypeField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(parentIDHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(childIDHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription completeIndex = new IndexDescription(true, new String[]{ownerIDField, parentIDHashField, linkTypeField, childIDHashField});
            IndexDescription jobChildIndex = new IndexDescription(false, new String[]{jobIDField, childIDHashField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (completeIndex != null && id.equals((Object)completeIndex)) {
                    completeIndex = null;
                    continue;
                }
                if (jobChildIndex != null && id.equals((Object)jobChildIndex)) {
                    jobChildIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (completeIndex != null) {
                this.performAddIndex(null, completeIndex);
            }
            if (jobChildIndex == null) break block5;
            this.performAddIndex(null, jobChildIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void analyzeTables() throws ManifoldCFException {
        long startTime = System.currentTimeMillis();
        Logging.perf.debug((Object)"Beginning to analyze hopdeletedeps table");
        this.analyzeTable();
        Logging.perf.debug((Object)("Done analyzing hopdeletedeps table in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
    }

    public void deleteJob(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
        this.performDelete("WHERE " + query, list, null);
        this.noteModifications(0, 0, 1);
    }

    public void removeMarkedRows(String parentTable, String parentIDHashField, String query, ArrayList queryList) throws ManifoldCFException {
        this.performDelete("WHERE ownerid IN(SELECT " + parentIDHashField + " FROM " + parentTable + " WHERE " + query + ")", queryList, null);
        this.noteModifications(0, 0, 1);
    }

    public void deleteOwnerRows(Long[] ownerIDs) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(ownerIDField, (Object[])ownerIDs)});
        this.performDelete("WHERE " + query, list, null);
        this.noteModifications(0, 0, ownerIDs.length);
    }

    public DeleteDependency[] getDeleteDependencies(Long ownerID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)});
        IResultSet set = this.performQuery("SELECT linktype, parentidhash, childidhash FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        DeleteDependency[] rval = new DeleteDependency[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = new DeleteDependency((String)row.getValue(linkTypeField), (String)row.getValue(parentIDHashField), (String)row.getValue(childIDHashField));
        }
        return rval;
    }

    public void deleteDependency(Long ownerID, DeleteDependency dd) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID), new UnitaryClause(parentIDHashField, (Object)dd.getParentIDHash()), dd.getLinkType().length() > 0 ? new UnitaryClause(linkTypeField, (Object)dd.getLinkType()) : new NullCheckClause(linkTypeField, true), dd.getChildIDHash().length() > 0 ? new UnitaryClause(childIDHashField, (Object)dd.getChildIDHash()) : new NullCheckClause(childIDHashField, true)});
        this.performDelete("WHERE " + query, list, null);
        this.noteModifications(0, 0, 1);
    }

    public void writeDependency(Long ownerID, Long jobID, DeleteDependency dd) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(jobIDField, jobID);
        map.put(ownerIDField, ownerID);
        if (dd.getLinkType().length() > 0) {
            map.put(linkTypeField, dd.getLinkType());
        }
        map.put(parentIDHashField, dd.getParentIDHash());
        if (dd.getChildIDHash().length() > 0) {
            map.put(childIDHashField, dd.getChildIDHash());
        }
        this.performInsert(map, null);
        this.noteModifications(1, 0, 0);
    }
}

