/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.handler.codec.http.DefaultHttpHeaders;
import org.elasticsearch.common.netty.handler.codec.http.HttpChunkTrailer;
import org.elasticsearch.common.netty.handler.codec.http.HttpHeaders;
import org.elasticsearch.common.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpChunkTrailer
implements HttpChunkTrailer {
    private final HttpHeaders trailingHeaders = new TrailingHeaders(true);

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    @Deprecated
    public void addHeader(String name, Object value) {
        this.trailingHeaders.add(name, value);
    }

    @Override
    @Deprecated
    public void setHeader(String name, Object value) {
        this.trailingHeaders.set(name, value);
    }

    @Override
    @Deprecated
    public void setHeader(String name, Iterable<?> values) {
        this.trailingHeaders.set(name, values);
    }

    @Override
    @Deprecated
    public void removeHeader(String name) {
        this.trailingHeaders.remove(name);
    }

    @Override
    @Deprecated
    public void clearHeaders() {
        this.trailingHeaders.clear();
    }

    @Override
    @Deprecated
    public String getHeader(String name) {
        return this.trailingHeaders.get(name);
    }

    @Override
    @Deprecated
    public List<String> getHeaders(String name) {
        return this.trailingHeaders.getAll(name);
    }

    @Override
    @Deprecated
    public List<Map.Entry<String, String>> getHeaders() {
        return this.trailingHeaders.entries();
    }

    @Override
    @Deprecated
    public boolean containsHeader(String name) {
        return this.trailingHeaders.contains(name);
    }

    @Override
    @Deprecated
    public Set<String> getHeaderNames() {
        return this.trailingHeaders.names();
    }

    @Override
    public ChannelBuffer getContent() {
        return ChannelBuffers.EMPTY_BUFFER;
    }

    @Override
    public void setContent(ChannelBuffer content) {
        throw new IllegalStateException("read-only");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.trailingHeaders()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrailingHeaders
    extends DefaultHttpHeaders {
        TrailingHeaders(boolean validateHeaders) {
            super(validateHeaders);
        }

        @Override
        public HttpHeaders add(String name, Object value) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.add(name, value);
        }

        @Override
        public HttpHeaders add(String name, Iterable<?> values) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.add(name, values);
        }

        @Override
        public HttpHeaders set(String name, Iterable<?> values) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.set(name, values);
        }

        @Override
        public HttpHeaders set(String name, Object value) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.set(name, value);
        }

        private static void validateName(String name) {
            if (name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer")) {
                throw new IllegalArgumentException("prohibited trailing header: " + name);
            }
        }
    }
}

