/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.core.interfaces.LockException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.lockmanager.LockObject;
import org.apache.manifoldcf.core.lockmanager.LockPool;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class FileLockObject
extends LockObject {
    public static final String _rcsid = "@(#)$Id: LockObject.java 988245 2010-08-23 18:39:35Z kwright $";
    private static final int STATUS_WRITELOCKED = -1;
    private File lockDirectoryName = null;
    private File lockFileName = null;
    private boolean isSync;
    private static final String DOTLOCK = ".lock";
    private static final String DOTFILE = ".file";
    private static final String SLASH = "/";
    private static final String FILELOCKED = "File locked";

    public FileLockObject(LockPool lockPool, Object lockKey, File synchDir) {
        super(lockPool, lockKey);
        boolean bl = this.isSync = synchDir != null;
        if (this.isSync) {
            int hashcode = lockKey.hashCode();
            int outerDirNumber = hashcode & 0x3FF;
            int innerDirNumber = hashcode >> 10 & 0x3FF;
            String fullDir = synchDir.toString();
            if (fullDir.length() == 0 || !fullDir.endsWith(SLASH)) {
                fullDir = fullDir + SLASH;
            }
            fullDir = fullDir + Integer.toString(outerDirNumber) + SLASH + Integer.toString(innerDirNumber);
            new File(fullDir).mkdirs();
            String filename = FileLockObject.createFileName(lockKey);
            this.lockDirectoryName = new File(fullDir, filename + DOTLOCK);
            this.lockFileName = new File(fullDir, filename + DOTFILE);
        }
    }

    private static String createFileName(Object lockKey) {
        return "lock-" + ManifoldCF.safeFileName(lockKey.toString());
    }

    @Override
    protected void obtainGlobalWriteLockNoWait() throws ManifoldCFException, LockException, InterruptedException {
        if (this.isSync) {
            this.grabFileLock();
            try {
                int status = this.readFile();
                if (status != 0) {
                    throw new LockException("Locked by another JVM");
                }
                this.writeFile(-1);
            }
            finally {
                this.releaseFileLock();
            }
        }
    }

    @Override
    protected void clearGlobalWriteLockNoWait() throws ManifoldCFException, LockException, InterruptedException {
        if (this.isSync) {
            this.grabFileLock();
            try {
                this.writeFile(0);
            }
            finally {
                this.releaseFileLock();
            }
        }
    }

    @Override
    protected void obtainGlobalNonExWriteLockNoWait() throws ManifoldCFException, LockException, InterruptedException {
        if (this.isSync) {
            this.grabFileLock();
            try {
                int status = this.readFile();
                if (status == -1 || status > 0) {
                    throw new LockException("Locked by another JVM");
                }
                if (status == 0) {
                    status = -1;
                }
                this.writeFile(--status);
            }
            finally {
                this.releaseFileLock();
            }
        }
    }

    @Override
    protected void clearGlobalNonExWriteLockNoWait() throws ManifoldCFException, LockException, InterruptedException {
        if (this.isSync) {
            this.grabFileLock();
            try {
                int status = this.readFile();
                if (status >= -1) {
                    throw new RuntimeException("JVM error: File lock is not in expected state for object " + this.toString());
                }
                if (++status == -1) {
                    status = 0;
                }
                this.writeFile(status);
            }
            finally {
                this.releaseFileLock();
            }
        }
    }

    @Override
    protected void obtainGlobalReadLockNoWait() throws ManifoldCFException, LockException, InterruptedException {
        if (this.isSync) {
            this.grabFileLock();
            try {
                int status = this.readFile();
                if (status <= -1) {
                    throw new LockException("Locked by another JVM");
                }
                this.writeFile(++status);
            }
            finally {
                this.releaseFileLock();
            }
        }
    }

    @Override
    protected void clearGlobalReadLockNoWait() throws ManifoldCFException, LockException, InterruptedException {
        if (this.isSync) {
            this.grabFileLock();
            try {
                int status = this.readFile();
                if (status == 0) {
                    throw new RuntimeException("JVM error: File lock is not in expected state for object " + this.toString());
                }
                this.writeFile(--status);
            }
            finally {
                this.releaseFileLock();
            }
        }
    }

    private synchronized void grabFileLock() throws LockException, InterruptedException {
        while (true) {
            try {
                if (!this.lockDirectoryName.createNewFile()) {
                    throw new LockException(FILELOCKED);
                }
            }
            catch (InterruptedIOException e) {
                throw new InterruptedException("Interrupted IO: " + e.getMessage());
            }
            catch (IOException e) {
                try {
                    Logging.lock.warn((Object)("Attempt to set file lock '" + this.lockDirectoryName.toString() + "' failed: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable e2) {
                    e.printStackTrace();
                }
                ManifoldCF.sleep(100L);
                continue;
            }
            break;
        }
    }

    private synchronized void releaseFileLock() throws InterruptedException {
        Throwable ie = null;
        while (true) {
            String message;
            try {
                while (!this.lockDirectoryName.delete()) {
                    try {
                        Logging.lock.fatal((Object)("Failure deleting file lock '" + this.lockDirectoryName.toString() + "'"));
                    }
                    catch (Throwable e2) {
                        System.out.println("Failure deleting file lock '" + this.lockDirectoryName.toString() + "'");
                    }
                    System.exit(-100);
                }
            }
            catch (Error e) {
                message = "Error deleting file lock '" + this.lockDirectoryName.toString() + "': " + e.getMessage();
                try {
                    Logging.lock.error((Object)message, (Throwable)e);
                }
                catch (Throwable e2) {
                    System.out.println(message);
                    e.printStackTrace();
                }
                ie = e;
                ManifoldCF.sleep(100L);
                continue;
            }
            catch (RuntimeException e) {
                message = "Error deleting file lock '" + this.lockDirectoryName.toString() + "': " + e.getMessage();
                try {
                    Logging.lock.error((Object)message, (Throwable)e);
                }
                catch (Throwable e2) {
                    System.out.println(message);
                    e.printStackTrace();
                }
                ie = e;
                ManifoldCF.sleep(100L);
                continue;
            }
            break;
        }
        if (ie != null) {
            if (ie instanceof InterruptedException) {
                throw (InterruptedException)ie;
            }
            if (ie instanceof Error) {
                throw (Error)ie;
            }
            if (ie instanceof RuntimeException) {
                throw (RuntimeException)ie;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized int readFile() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeFile(int value) throws InterruptedException {
        block19: {
            try {
                if (value == 0) {
                    if (!this.lockFileName.delete()) {
                        throw new IOException("Could not delete file '" + this.lockFileName.toString() + "'");
                    }
                    break block19;
                }
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.lockFileName), StandardCharsets.UTF_8);
                     BufferedWriter x = new BufferedWriter(osw);){
                    x.write(Integer.toString(value));
                }
            }
            catch (Error e) {
                String message = "Couldn't write to lock file; hard error occurred.  Shutting down process; locks may be left dangling.  You must cleanup before restarting.";
                try {
                    Logging.lock.error((Object)message, (Throwable)e);
                }
                catch (Throwable e2) {
                    System.out.println(message);
                    e.printStackTrace();
                }
                System.exit(-100);
            }
            catch (RuntimeException e) {
                String message = "Couldn't write to lock file; JVM error.  Shutting down process; locks may be left dangling.  You must cleanup before restarting.";
                try {
                    Logging.lock.error((Object)message, (Throwable)e);
                }
                catch (Throwable e2) {
                    System.out.println(message);
                    e.printStackTrace();
                }
                System.exit(-100);
            }
            catch (InterruptedIOException e) {
                throw new InterruptedException("Interrupted IO: " + e.getMessage());
            }
            catch (IOException e) {
                String message = "Couldn't write to lock file; disk may be full.  Shutting down process; locks may be left dangling.  You must cleanup before restarting.";
                try {
                    Logging.lock.error((Object)message, (Throwable)e);
                }
                catch (Throwable e2) {
                    System.out.println(message);
                    e.printStackTrace();
                }
                System.exit(-100);
            }
        }
    }
}

