/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.image;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;

final class CompoundFuture<R>
implements Future<R> {
    private final Future<R>[] components;

    private CompoundFuture(Future<R>[] futureArray) {
        this.components = futureArray;
    }

    public static <R> Future<R> create(Future<R>[] futureArray) {
        switch (futureArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return futureArray[0];
            }
        }
        return new CompoundFuture<R>(futureArray);
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = false;
        for (Future<R> future : this.components) {
            bl2 |= future.cancel(bl);
        }
        return bl2;
    }

    @Override
    public boolean isCancelled() {
        for (Future<R> future : this.components) {
            if (!future.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        for (Future<R> future : this.components) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, true);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    @Override
    public R get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get(System.nanoTime() + TimeUnit.NANOSECONDS.convert(l, timeUnit), false);
    }

    private R get(long l, boolean bl) throws InterruptedException, ExecutionException, TimeoutException {
        Object e = null;
        HashSet<Object> hashSet = null;
        for (Future<R> future : this.components) {
            R r;
            R r2 = r = bl ? future.get() : future.get(Math.max(0L, l - System.nanoTime()), TimeUnit.NANOSECONDS);
            if (r == null) continue;
            if (e == null) {
                e = r;
                continue;
            }
            if (r == e) continue;
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                hashSet.add(e);
            }
            hashSet.add(r);
        }
        if (hashSet != null) {
            e = this.merge(hashSet);
        }
        return (R)e;
    }

    protected R merge(Set<R> set) {
        R r = CollectionsExt.singletonOrNull(set);
        if (r != null) {
            return r;
        }
        throw new IllegalStateException(Resources.format((short)53, "get()"));
    }
}

