/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import java.util.Map;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierBase;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;

public abstract class DefaultClassCopiers {
    private static ClassCopier identityClassCopier = new ClassCopierBase("identity"){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            return source;
        }
    };
    private static ClassCopier errorClassCopier = new ClassCopierBase("error", true){

        @Override
        public Object createCopy(Object source) throws ReflectiveCopyException {
            throw new ReflectiveCopyException("Cannot copy class " + source.getClass());
        }
    };

    private DefaultClassCopiers() {
    }

    public static ClassCopier getIdentityClassCopier() {
        return identityClassCopier;
    }

    public static ClassCopier getErrorClassCopier() {
        return errorClassCopier;
    }

    public static ClassCopier makeMapClassCopier(final ClassCopierFactory ccf) {
        return new ClassCopierBase("map"){

            @Override
            public Object createCopy(Object source) throws ReflectiveCopyException {
                try {
                    return source.getClass().newInstance();
                }
                catch (Exception exc) {
                    throw new ReflectiveCopyException("MapCopier could not copy " + source.getClass(), exc);
                }
            }

            private Object myCopy(Map<Object, Object> oldToNew, Object obj) throws ReflectiveCopyException {
                if (obj == null) {
                    return null;
                }
                Class<?> cls = obj.getClass();
                ClassCopier copier = ccf.getClassCopier(cls);
                return copier.copy(oldToNew, obj);
            }

            @Override
            public Object doCopy(Map<Object, Object> oldToNew, Object source, Object result) throws ReflectiveCopyException {
                Map sourceMap = (Map)source;
                Map resultMap = (Map)result;
                for (Map.Entry entry : sourceMap.entrySet()) {
                    Object key = entry.getKey();
                    Object newKey = this.myCopy(oldToNew, key);
                    Object value = entry.getValue();
                    Object newValue = this.myCopy(oldToNew, value);
                    resultMap.put(newKey, newValue);
                }
                return result;
            }
        };
    }
}

