/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.UriParser;

public abstract class AbstractFileName
implements FileName {
    private final String scheme;
    private final String absPath;
    private FileType type;
    private String uri;
    private String baseName;
    private String rootUri = null;
    private String extension;
    private String decodedAbsPath;
    private String key = null;

    public AbstractFileName(String scheme, String absPath, FileType type) {
        this.scheme = scheme;
        this.type = type;
        this.absPath = absPath != null && absPath.length() > 0 ? (absPath.length() > 1 && absPath.endsWith("/") ? absPath.substring(0, absPath.length() - 1) : absPath) : "/";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileName that = (AbstractFileName)o;
        return this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public int compareTo(FileName obj) {
        AbstractFileName name = (AbstractFileName)obj;
        return this.getKey().compareTo(name.getKey());
    }

    public String toString() {
        return this.getURI();
    }

    public abstract FileName createName(String var1, FileType var2);

    protected abstract void appendRootUri(StringBuilder var1, boolean var2);

    public String getBaseName() {
        if (this.baseName == null) {
            int idx = this.getPath().lastIndexOf(47);
            this.baseName = idx == -1 ? this.getPath() : this.getPath().substring(idx + 1);
        }
        return this.baseName;
    }

    public String getPath() {
        if (VFS.isUriStyle()) {
            return this.absPath + this.getUriTrailer();
        }
        return this.absPath;
    }

    protected String getUriTrailer() {
        return this.getType().hasChildren() ? "/" : "";
    }

    public String getPathDecoded() throws FileSystemException {
        if (this.decodedAbsPath == null) {
            this.decodedAbsPath = UriParser.decode(this.getPath());
        }
        return this.decodedAbsPath;
    }

    public FileName getParent() {
        int idx = this.getPath().lastIndexOf(47);
        if (idx == -1 || idx == this.getPath().length() - 1) {
            return null;
        }
        String parentPath = idx == 0 ? "/" : this.getPath().substring(0, idx);
        return this.createName(parentPath, FileType.FOLDER);
    }

    public FileName getRoot() {
        FileName root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getURI() {
        if (this.uri == null) {
            this.uri = this.createURI();
        }
        return this.uri;
    }

    protected String createURI() {
        return this.createURI(false, true);
    }

    private String getKey() {
        if (this.key == null) {
            this.key = this.createURI(true, true);
        }
        return this.key;
    }

    public String getFriendlyURI() {
        return this.createURI(false, false);
    }

    private String createURI(boolean useAbsolutePath, boolean usePassword) {
        StringBuilder buffer = new StringBuilder();
        this.appendRootUri(buffer, usePassword);
        buffer.append(useAbsolutePath ? this.absPath : this.getPath());
        return buffer.toString();
    }

    public String getRelativeName(FileName name) throws FileSystemException {
        int pos;
        String path = name.getPath();
        int basePathLen = this.getPath().length();
        int pathLen = path.length();
        if (basePathLen == 1 && pathLen == 1) {
            return ".";
        }
        if (basePathLen == 1) {
            return path.substring(1);
        }
        int maxlen = Math.min(basePathLen, pathLen);
        for (pos = 0; pos < maxlen && this.getPath().charAt(pos) == path.charAt(pos); ++pos) {
        }
        if (pos == basePathLen && pos == pathLen) {
            return ".";
        }
        if (pos == basePathLen && pos < pathLen && path.charAt(pos) == '/') {
            return path.substring(pos + 1);
        }
        StringBuilder buffer = new StringBuilder();
        if (pathLen > 1 && (pos < pathLen || this.getPath().charAt(pos) != '/')) {
            pos = this.getPath().lastIndexOf(47, pos);
            buffer.append(path.substring(pos));
        }
        buffer.insert(0, "..");
        pos = this.getPath().indexOf(47, pos + 1);
        while (pos != -1) {
            buffer.insert(0, "../");
            pos = this.getPath().indexOf(47, pos + 1);
        }
        return buffer.toString();
    }

    public String getRootURI() {
        if (this.rootUri == null) {
            StringBuilder buffer = new StringBuilder();
            this.appendRootUri(buffer, true);
            buffer.append('/');
            this.rootUri = buffer.toString().intern();
        }
        return this.rootUri;
    }

    public int getDepth() {
        int len = this.getPath().length();
        if (len == 0 || len == 1 && this.getPath().charAt(0) == '/') {
            return 0;
        }
        int depth = 1;
        int pos = 0;
        while (pos > -1 && pos < len) {
            pos = this.getPath().indexOf(47, pos + 1);
            ++depth;
        }
        return depth;
    }

    public String getExtension() {
        if (this.extension == null) {
            this.getBaseName();
            int pos = this.baseName.lastIndexOf(46);
            this.extension = pos < 1 || pos == this.baseName.length() - 1 ? "" : this.baseName.substring(pos + 1).intern();
        }
        return this.extension;
    }

    public boolean isAncestor(FileName ancestor) {
        if (!ancestor.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        return AbstractFileName.checkName(ancestor.getPath(), this.getPath(), NameScope.DESCENDENT);
    }

    public boolean isDescendent(FileName descendent) {
        return this.isDescendent(descendent, NameScope.DESCENDENT);
    }

    public boolean isDescendent(FileName descendent, NameScope scope) {
        if (!descendent.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        return AbstractFileName.checkName(this.getPath(), descendent.getPath(), scope);
    }

    public FileType getType() {
        return this.type;
    }

    void setType(FileType type) throws FileSystemException {
        if (type != FileType.FOLDER && type != FileType.FILE && type != FileType.FILE_OR_FOLDER) {
            throw new FileSystemException("vfs.provider/filename-type.error");
        }
        this.type = type;
    }

    public static boolean checkName(String basePath, String path, NameScope scope) {
        if (scope == NameScope.FILE_SYSTEM) {
            return true;
        }
        if (!path.startsWith(basePath)) {
            return false;
        }
        int baseLen = basePath.length();
        if (VFS.isUriStyle()) {
            --baseLen;
        }
        if (scope == NameScope.CHILD) {
            if (path.length() == baseLen || baseLen > 1 && path.charAt(baseLen) != '/' || path.indexOf(47, baseLen + 1) != -1) {
                return false;
            }
        } else if (scope == NameScope.DESCENDENT) {
            if (path.length() == baseLen || baseLen > 1 && path.charAt(baseLen) != '/') {
                return false;
            }
        } else if (scope == NameScope.DESCENDENT_OR_SELF) {
            if (baseLen > 1 && path.length() > baseLen && path.charAt(baseLen) != '/') {
                return false;
            }
        } else if (scope != NameScope.FILE_SYSTEM) {
            throw new IllegalArgumentException();
        }
        return true;
    }
}

