/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.builder;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.MultilineMessageHelper;
import org.apache.maven.internal.impl.DefaultLifecycleRegistry;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class BuilderCommon {
    private final Logger logger;
    private final LifecycleDebugLogger lifecycleDebugLogger;
    private final LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator;
    private final ExecutionEventCatapult eventCatapult;

    @Inject
    public BuilderCommon(LifecycleDebugLogger lifecycleDebugLogger, LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator, ExecutionEventCatapult eventCatapult) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.lifecycleDebugLogger = lifecycleDebugLogger;
        this.lifeCycleExecutionPlanCalculator = lifeCycleExecutionPlanCalculator;
        this.eventCatapult = eventCatapult;
    }

    BuilderCommon(LifecycleDebugLogger lifecycleDebugLogger, LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator, ExecutionEventCatapult eventCatapult, Logger logger) {
        this.lifecycleDebugLogger = lifecycleDebugLogger;
        this.lifeCycleExecutionPlanCalculator = lifeCycleExecutionPlanCalculator;
        this.eventCatapult = eventCatapult;
        this.logger = logger;
    }

    public MavenExecutionPlan resolveBuildPlan(MavenSession session, MavenProject project, TaskSegment taskSegment, Set<Artifact> projectArtifacts) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException, LifecycleExecutionException {
        Set<Plugin> unsafePlugins;
        MavenExecutionPlan executionPlan = this.lifeCycleExecutionPlanCalculator.calculateExecutionPlan(session, project, taskSegment.getTasks());
        this.lifecycleDebugLogger.debugProjectPlan(project, executionPlan);
        if (session.getRequest().getDegreeOfConcurrency() > 1 && session.getProjects().size() > 1 && !(unsafePlugins = executionPlan.getNonThreadSafePlugins()).isEmpty()) {
            for (String string : MultilineMessageHelper.format("Your build is requesting parallel execution, but this project contains the following plugin(s) that have goals not marked as thread-safe to support parallel execution.", "While this /may/ work fine, please look for plugin updates and/or request plugins be made thread-safe.", "If reporting an issue, report it against the plugin in question, not against Apache Maven.")) {
                this.logger.warn(string);
            }
            if (this.logger.isDebugEnabled()) {
                Set<MojoDescriptor> unsafeGoals = executionPlan.getNonThreadSafeMojos();
                this.logger.warn("The following goals are not marked as thread-safe in " + project.getName() + ":");
                Iterator iterator = unsafeGoals.iterator();
                while (iterator.hasNext()) {
                    MojoDescriptor unsafeGoal = (MojoDescriptor)iterator.next();
                    this.logger.warn("  " + unsafeGoal.getId());
                }
            } else {
                this.logger.warn("The following plugins are not marked as thread-safe in " + project.getName() + ":");
                for (Plugin plugin : unsafePlugins) {
                    this.logger.warn("  " + plugin.getId());
                }
                this.logger.warn("");
                this.logger.warn("Enable verbose output (-X) to see precisely which goals are not marked as thread-safe.");
            }
            this.logger.warn(MultilineMessageHelper.separatorLine());
        }
        String defaulModelId = DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_MODELID;
        List<String> unversionedPlugins = executionPlan.getMojoExecutions().stream().map(MojoExecution::getPlugin).filter(p -> p.getLocation((Object)"version") != null && p.getLocation((Object)"version").getSource() != null && defaulModelId.equals(p.getLocation((Object)"version").getSource().getModelId())).distinct().map(Plugin::getArtifactId).toList();
        if (!unversionedPlugins.isEmpty()) {
            this.logger.warn("Version not locked for default bindings plugins " + String.valueOf(unversionedPlugins) + ", you should define versions in pluginManagement section of your pom.xml or parent");
        }
        return executionPlan;
    }

    public void handleBuildError(ReactorContext buildContext, MavenSession rootSession, MavenSession currentSession, MavenProject mavenProject, Throwable t, Instant buildStartTime) {
        Instant buildEndTime = MonotonicClock.now();
        buildContext.getResult().addException(t);
        buildContext.getResult().addBuildSummary(new BuildFailure(mavenProject, Duration.between(buildStartTime, buildEndTime), t));
        if (t instanceof Exception) {
            Exception exception = (Exception)t;
            if (!(t instanceof RuntimeException)) {
                this.eventCatapult.fire(ExecutionEvent.Type.ProjectFailed, currentSession, null, exception);
            }
        }
        if (t instanceof RuntimeException || !(t instanceof Exception)) {
            buildContext.getReactorBuildStatus().halt();
        } else if (!"FAIL_NEVER".equals(rootSession.getReactorFailureBehavior())) {
            if ("FAIL_AT_END".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().blackList(mavenProject);
            } else if ("FAIL_FAST".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().halt();
            } else {
                this.logger.error("invalid reactor failure behavior " + rootSession.getReactorFailureBehavior());
                buildContext.getReactorBuildStatus().halt();
            }
        }
    }

    public static void attachToThread(MavenProject currentProject) {
        ClassRealm projectRealm = currentProject.getClassRealm();
        if (projectRealm != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
        }
    }

    public static String getKey(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
    }
}

