/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.impl.digester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.element.Application;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.Converter;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigExtension;
import org.apache.myfaces.config.element.Factory;
import org.apache.myfaces.config.element.LocaleConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.SystemEventListener;
import org.apache.myfaces.config.impl.digester.elements.RenderKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigesterFacesConfigDispenserImpl
extends FacesConfigDispenser {
    private static final long serialVersionUID = 3550379003287939559L;
    private List<String> applicationFactories = new ArrayList<String>();
    private List<String> exceptionHandlerFactories = new ArrayList<String>();
    private List<String> externalContextFactories = new ArrayList<String>();
    private List<String> facesContextFactories = new ArrayList<String>();
    private List<String> lifecycleFactories = new ArrayList<String>();
    private List<String> ViewDeclarationLanguageFactories = new ArrayList<String>();
    private List<String> partialViewContextFactories = new ArrayList<String>();
    private List<String> renderKitFactories = new ArrayList<String>();
    private List<String> tagHandlerDelegateFactories = new ArrayList<String>();
    private List<String> visitContextFactories = new ArrayList<String>();
    private List<String> faceletCacheFactories = new ArrayList<String>();
    private String defaultRenderKitId;
    private String messageBundle;
    private String partialTraversal;
    private String facesVersion;
    private LocaleConfig localeConfig;
    private Map<String, String> components = new HashMap<String, String>();
    private Map<String, String> converterByClass = new HashMap<String, String>();
    private Map<String, String> converterById = new HashMap<String, String>();
    private Map<String, String> validators = new HashMap<String, String>();
    private List<Behavior> behaviors = new ArrayList<Behavior>();
    private Map<String, Converter> converterConfigurationByClassName = new HashMap<String, Converter>();
    private Map<String, RenderKit> renderKits = new LinkedHashMap<String, RenderKit>();
    private List<String> actionListeners = new ArrayList<String>();
    private List<String> elResolvers = new ArrayList<String>();
    private List<String> lifecyclePhaseListeners = new ArrayList<String>();
    private List<String> navigationHandlers = new ArrayList<String>();
    private List<String> propertyResolver = new ArrayList<String>();
    private List<String> resourceHandlers = new ArrayList<String>();
    private List<String> stateManagers = new ArrayList<String>();
    private List<String> variableResolver = new ArrayList<String>();
    private List<String> viewHandlers = new ArrayList<String>();
    private List<String> defaultValidatorIds = new ArrayList<String>();
    private List<String> defaultAnnotatedValidatorIds = new ArrayList<String>();
    private List<ManagedBean> managedBeans = new ArrayList<ManagedBean>();
    private List<NavigationRule> navigationRules = new ArrayList<NavigationRule>();
    private List<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
    private List<SystemEventListener> systemEventListeners = new ArrayList<SystemEventListener>();
    private List<NamedEvent> namedEvents = new ArrayList<NamedEvent>();
    private Map<String, FaceletsProcessing> faceletsProcessingByFileExtension = new HashMap<String, FaceletsProcessing>();

    @Override
    public void feed(FacesConfig config) {
        for (Factory factory : config.getFactories()) {
            this.applicationFactories.addAll(factory.getApplicationFactory());
            this.exceptionHandlerFactories.addAll(factory.getExceptionHandlerFactory());
            this.externalContextFactories.addAll(factory.getExternalContextFactory());
            this.facesContextFactories.addAll(factory.getFacesContextFactory());
            this.lifecycleFactories.addAll(factory.getLifecycleFactory());
            this.ViewDeclarationLanguageFactories.addAll(factory.getViewDeclarationLanguageFactory());
            this.partialViewContextFactories.addAll(factory.getPartialViewContextFactory());
            this.renderKitFactories.addAll(factory.getRenderkitFactory());
            this.tagHandlerDelegateFactories.addAll(factory.getTagHandlerDelegateFactory());
            this.visitContextFactories.addAll(factory.getVisitContextFactory());
            this.faceletCacheFactories.addAll(factory.getFaceletCacheFactory());
        }
        this.components.putAll(config.getComponents());
        this.validators.putAll(config.getValidators());
        this.behaviors.addAll(config.getBehaviors());
        for (Application application : config.getApplications()) {
            if (!application.getDefaultRenderkitId().isEmpty()) {
                this.defaultRenderKitId = application.getDefaultRenderkitId().get(application.getDefaultRenderkitId().size() - 1);
            }
            if (!application.getMessageBundle().isEmpty()) {
                this.messageBundle = application.getMessageBundle().get(application.getMessageBundle().size() - 1);
            }
            if (!application.getLocaleConfig().isEmpty()) {
                this.localeConfig = application.getLocaleConfig().get(application.getLocaleConfig().size() - 1);
            }
            if (!application.getPartialTraversal().isEmpty()) {
                this.partialTraversal = application.getPartialTraversal().get(application.getPartialTraversal().size() - 1);
            }
            this.actionListeners.addAll(application.getActionListener());
            this.navigationHandlers.addAll(application.getNavigationHandler());
            this.resourceHandlers.addAll(application.getResourceHandler());
            this.viewHandlers.addAll(application.getViewHandler());
            this.stateManagers.addAll(application.getStateManager());
            this.propertyResolver.addAll(application.getPropertyResolver());
            this.variableResolver.addAll(application.getVariableResolver());
            this.resourceBundles.addAll(application.getResourceBundle());
            this.elResolvers.addAll(application.getElResolver());
            if (application.isDefaultValidatorsPresent()) {
                this.defaultValidatorIds.clear();
                this.defaultValidatorIds.addAll(application.getDefaultValidatorIds());
            } else {
                this.defaultAnnotatedValidatorIds.addAll(application.getDefaultValidatorIds());
            }
            this.systemEventListeners.addAll(application.getSystemEventListeners());
        }
        for (Converter converter : config.getConverters()) {
            if (converter.getConverterId() != null) {
                this.converterById.put(converter.getConverterId(), converter.getConverterClass());
            }
            if (converter.getForClass() != null) {
                this.converterByClass.put(converter.getForClass(), converter.getConverterClass());
            }
            this.converterConfigurationByClassName.put(converter.getConverterClass(), converter);
        }
        for (org.apache.myfaces.config.element.RenderKit renderKit : config.getRenderKits()) {
            RenderKit existing;
            String renderKitId = renderKit.getId();
            if (renderKitId == null) {
                renderKitId = "HTML_BASIC";
            }
            if ((existing = this.renderKits.get(renderKitId)) == null) {
                existing = new RenderKit();
                existing.merge(renderKit);
                this.renderKits.put(renderKitId, existing);
                continue;
            }
            existing.merge(renderKit);
        }
        for (FacesConfigExtension extension : config.getFacesConfigExtensions()) {
            for (FaceletsProcessing faceletsProcessing : extension.getFaceletsProcessingList()) {
                if (faceletsProcessing.getFileExtension() == null || faceletsProcessing.getFileExtension().length() <= 0) continue;
                this.faceletsProcessingByFileExtension.put(faceletsProcessing.getFileExtension(), faceletsProcessing);
            }
        }
        this.lifecyclePhaseListeners.addAll(config.getLifecyclePhaseListener());
        this.managedBeans.addAll(config.getManagedBeans());
        this.navigationRules.addAll(config.getNavigationRules());
        this.facesVersion = config.getVersion();
        this.namedEvents.addAll(config.getNamedEvents());
    }

    @Override
    public void feedApplicationFactory(String factoryClassName) {
        this.applicationFactories.add(factoryClassName);
    }

    @Override
    public void feedExceptionHandlerFactory(String factoryClassName) {
        this.exceptionHandlerFactories.add(factoryClassName);
    }

    @Override
    public void feedExternalContextFactory(String factoryClassName) {
        this.externalContextFactories.add(factoryClassName);
    }

    @Override
    public void feedFacesContextFactory(String factoryClassName) {
        this.facesContextFactories.add(factoryClassName);
    }

    @Override
    public void feedLifecycleFactory(String factoryClassName) {
        this.lifecycleFactories.add(factoryClassName);
    }

    @Override
    public void feedViewDeclarationLanguageFactory(String factoryClassName) {
        this.ViewDeclarationLanguageFactories.add(factoryClassName);
    }

    @Override
    public void feedPartialViewContextFactory(String factoryClassName) {
        this.partialViewContextFactories.add(factoryClassName);
    }

    @Override
    public void feedRenderKitFactory(String factoryClassName) {
        this.renderKitFactories.add(factoryClassName);
    }

    @Override
    public void feedTagHandlerDelegateFactory(String factoryClassName) {
        this.tagHandlerDelegateFactories.add(factoryClassName);
    }

    @Override
    public void feedVisitContextFactory(String factoryClassName) {
        this.visitContextFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getApplicationFactoryIterator() {
        return this.applicationFactories;
    }

    @Override
    public Collection<String> getExceptionHandlerFactoryIterator() {
        return this.exceptionHandlerFactories;
    }

    @Override
    public Collection<String> getExternalContextFactoryIterator() {
        return this.externalContextFactories;
    }

    @Override
    public Collection<String> getFacesContextFactoryIterator() {
        return this.facesContextFactories;
    }

    @Override
    public Collection<String> getLifecycleFactoryIterator() {
        return this.lifecycleFactories;
    }

    @Override
    public Collection<String> getViewDeclarationLanguageFactoryIterator() {
        return this.ViewDeclarationLanguageFactories;
    }

    @Override
    public Collection<String> getPartialViewContextFactoryIterator() {
        return this.partialViewContextFactories;
    }

    @Override
    public Collection<String> getRenderKitFactoryIterator() {
        return this.renderKitFactories;
    }

    @Override
    public Collection<String> getTagHandlerDelegateFactoryIterator() {
        return this.tagHandlerDelegateFactories;
    }

    @Override
    public Collection<String> getVisitContextFactoryIterator() {
        return this.visitContextFactories;
    }

    @Override
    public Collection<String> getActionListenerIterator() {
        return new ArrayList<String>(this.actionListeners);
    }

    @Override
    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    @Override
    public String getMessageBundle() {
        return this.messageBundle;
    }

    @Override
    public Collection<String> getNavigationHandlerIterator() {
        return new ArrayList<String>(this.navigationHandlers);
    }

    @Override
    public String getPartialTraversal() {
        return this.partialTraversal;
    }

    @Override
    public Collection<String> getResourceHandlerIterator() {
        return new ArrayList<String>(this.resourceHandlers);
    }

    @Override
    public Collection<String> getViewHandlerIterator() {
        return new ArrayList<String>(this.viewHandlers);
    }

    @Override
    public Collection<String> getStateManagerIterator() {
        return new ArrayList<String>(this.stateManagers);
    }

    @Override
    public Collection<String> getPropertyResolverIterator() {
        return new ArrayList<String>(this.propertyResolver);
    }

    @Override
    public Collection<String> getVariableResolverIterator() {
        return new ArrayList<String>(this.variableResolver);
    }

    @Override
    public String getDefaultLocale() {
        if (this.localeConfig != null) {
            return this.localeConfig.getDefaultLocale();
        }
        return null;
    }

    @Override
    public Collection<String> getSupportedLocalesIterator() {
        List<String> locale = this.localeConfig != null ? this.localeConfig.getSupportedLocales() : Collections.emptyList();
        return locale;
    }

    @Override
    public Collection<String> getComponentTypes() {
        return this.components.keySet();
    }

    @Override
    public String getComponentClass(String componentType) {
        return this.components.get(componentType);
    }

    @Override
    public Collection<String> getConverterIds() {
        return this.converterById.keySet();
    }

    @Override
    public Collection<String> getConverterClasses() {
        return this.converterByClass.keySet();
    }

    @Override
    public Collection<String> getConverterConfigurationByClassName() {
        return this.converterConfigurationByClassName.keySet();
    }

    @Override
    public Converter getConverterConfiguration(String converterClassName) {
        return this.converterConfigurationByClassName.get(converterClassName);
    }

    @Override
    public String getConverterClassById(String converterId) {
        return this.converterById.get(converterId);
    }

    @Override
    public String getConverterClassByClass(String className) {
        return this.converterByClass.get(className);
    }

    @Override
    public Collection<String> getDefaultValidatorIds() {
        ArrayList<String> allDefaultValidatorIds = new ArrayList<String>();
        allDefaultValidatorIds.addAll(this.defaultAnnotatedValidatorIds);
        allDefaultValidatorIds.addAll(this.defaultValidatorIds);
        return allDefaultValidatorIds;
    }

    @Override
    public Collection<String> getValidatorIds() {
        return this.validators.keySet();
    }

    @Override
    public String getValidatorClass(String validatorId) {
        return this.validators.get(validatorId);
    }

    @Override
    public Collection<ManagedBean> getManagedBeans() {
        return this.managedBeans;
    }

    @Override
    public Collection<NavigationRule> getNavigationRules() {
        return this.navigationRules;
    }

    @Override
    public Collection<String> getRenderKitIds() {
        return this.renderKits.keySet();
    }

    @Override
    public Collection<String> getRenderKitClasses(String renderKitId) {
        return this.renderKits.get(renderKitId).getRenderKitClasses();
    }

    @Override
    public Collection<ClientBehaviorRenderer> getClientBehaviorRenderers(String renderKitId) {
        return this.renderKits.get(renderKitId).getClientBehaviorRenderers();
    }

    @Override
    public Collection<Renderer> getRenderers(String renderKitId) {
        return this.renderKits.get(renderKitId).getRenderer();
    }

    @Override
    public Collection<String> getLifecyclePhaseListeners() {
        return this.lifecyclePhaseListeners;
    }

    @Override
    public Collection<ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    @Override
    public Collection<String> getElResolvers() {
        return this.elResolvers;
    }

    @Override
    public Collection<SystemEventListener> getSystemEventListeners() {
        return this.systemEventListeners;
    }

    @Override
    public Collection<Behavior> getBehaviors() {
        return this.behaviors;
    }

    @Override
    public String getFacesVersion() {
        return this.facesVersion;
    }

    @Override
    public Collection<NamedEvent> getNamedEvents() {
        return this.namedEvents;
    }

    @Override
    public Collection<FaceletsProcessing> getFaceletsProcessing() {
        return this.faceletsProcessingByFileExtension.values();
    }

    public FaceletsProcessing getFaceletsProcessingConfiguration(String fileExtension) {
        return this.faceletsProcessingByFileExtension.get(fileExtension);
    }

    @Override
    public void feedFaceletCacheFactory(String factoryClassName) {
        this.faceletCacheFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getFaceletCacheFactoryIterator() {
        return this.faceletCacheFactories;
    }
}

