/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.AllAnnotationLifecycleProvider;
import org.apache.myfaces.config.annotation.DiscoverableLifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.annotation.NoAnnotationLifecyleProvider;
import org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider;
import org.apache.myfaces.config.annotation.ResourceAnnotationLifecycleProvider;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;

public class DefaultLifecycleProviderFactory
extends LifecycleProviderFactory {
    private static Logger log = Logger.getLogger(DefaultLifecycleProviderFactory.class.getName());
    public static final String LIFECYCLE_PROVIDER_INSTANCE_KEY = LifecycleProvider.class.getName() + ".LIFECYCLE_PROVIDER_INSTANCE";
    public static final String LIFECYCLE_PROVIDER = LifecycleProvider.class.getName();

    @Override
    public LifecycleProvider getLifecycleProvider(ExternalContext externalContext) {
        LifecycleProvider lifecycleProvider = null;
        if (externalContext == null) {
            log.info("No ExternalContext using fallback LifecycleProvider.");
            lifecycleProvider = this.resolveFallbackLifecycleProvider();
        } else {
            lifecycleProvider = (LifecycleProvider)externalContext.getApplicationMap().get(LIFECYCLE_PROVIDER_INSTANCE_KEY);
        }
        if (lifecycleProvider == null) {
            if (!this.resolveLifecycleProviderFromExternalContext(externalContext)) {
                if (!this.resolveLifecycleProviderFromService(externalContext)) {
                    lifecycleProvider = this.resolveFallbackLifecycleProvider();
                    externalContext.getApplicationMap().put(LIFECYCLE_PROVIDER_INSTANCE_KEY, lifecycleProvider);
                } else {
                    lifecycleProvider = (LifecycleProvider)externalContext.getApplicationMap().get(LIFECYCLE_PROVIDER_INSTANCE_KEY);
                }
            } else {
                lifecycleProvider = (LifecycleProvider)externalContext.getApplicationMap().get(LIFECYCLE_PROVIDER_INSTANCE_KEY);
            }
            log.info("Using LifecycleProvider " + lifecycleProvider.getClass().getName());
        }
        return lifecycleProvider;
    }

    @Override
    public void release() {
    }

    private boolean resolveLifecycleProviderFromExternalContext(ExternalContext externalContext) {
        try {
            Object obj;
            String lifecycleProvider = externalContext.getInitParameter(LIFECYCLE_PROVIDER);
            if (lifecycleProvider != null && (obj = this.createClass(lifecycleProvider, externalContext)) instanceof LifecycleProvider) {
                externalContext.getApplicationMap().put(LIFECYCLE_PROVIDER_INSTANCE_KEY, obj);
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        return false;
    }

    private boolean resolveLifecycleProviderFromService(ExternalContext externalContext) {
        boolean returnValue = false;
        final ExternalContext extContext = externalContext;
        try {
            if (System.getSecurityManager() != null) {
                returnValue = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
                        List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(extContext).getServiceProviderList(LIFECYCLE_PROVIDER);
                        for (String className : classList) {
                            DiscoverableLifecycleProvider discoverableLifecycleProvider;
                            Object obj = DefaultLifecycleProviderFactory.this.createClass(className, extContext);
                            if (!DiscoverableLifecycleProvider.class.isAssignableFrom(obj.getClass()) || !(discoverableLifecycleProvider = (DiscoverableLifecycleProvider)obj).isAvailable()) continue;
                            extContext.getApplicationMap().put(LIFECYCLE_PROVIDER_INSTANCE_KEY, discoverableLifecycleProvider);
                            return true;
                        }
                        return false;
                    }
                });
            } else {
                List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(extContext).getServiceProviderList(LIFECYCLE_PROVIDER);
                for (String className : classList) {
                    DiscoverableLifecycleProvider discoverableLifecycleProvider;
                    Object obj = this.createClass(className, extContext);
                    if (!DiscoverableLifecycleProvider.class.isAssignableFrom(obj.getClass()) || !(discoverableLifecycleProvider = (DiscoverableLifecycleProvider)obj).isAvailable()) continue;
                    extContext.getApplicationMap().put(LIFECYCLE_PROVIDER_INSTANCE_KEY, discoverableLifecycleProvider);
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classList) {
        }
        catch (NoClassDefFoundError classList) {
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException((Throwable)e);
        }
        return returnValue;
    }

    private Object createClass(String className, ExternalContext externalContext) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        try {
            return ClassUtils.newInstance(clazz, new Class[]{ExternalContext.class}, externalContext);
        }
        catch (NoSuchMethodException e) {
            return ClassUtils.newInstance(clazz);
        }
    }

    private LifecycleProvider resolveFallbackLifecycleProvider() {
        try {
            ClassUtils.classForName("javax.annotation.PreDestroy");
        }
        catch (ClassNotFoundException e) {
            return new NoAnnotationLifecyleProvider();
        }
        try {
            InitialContext context = new InitialContext();
            try {
                ClassUtils.classForName("javax.ejb.EJB");
                return new AllAnnotationLifecycleProvider(context);
            }
            catch (ClassNotFoundException e) {
                return new ResourceAnnotationLifecycleProvider(context);
            }
        }
        catch (NamingException e) {
            log.log(Level.SEVERE, "No InitialContext found. Using NoInjectionAnnotationProcessor.", e);
            return new NoInjectionAnnotationLifecycleProvider();
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.SEVERE, "No InitialContext class definition found. Using NoInjectionAnnotationProcessor.");
            return new NoInjectionAnnotationLifecycleProvider();
        }
    }
}

