/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.impl.DefaultAnnotationProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class AnnotationProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultAnnotationProviderFactory.class.getName();
    private static final String FACTORY_KEY = AnnotationProviderFactory.class.getName();

    public static AnnotationProviderFactory getAnnotationProviderFactory(ExternalContext ctx) {
        AnnotationProviderFactory instance = (AnnotationProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        AnnotationProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (AnnotationProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, AnnotationProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (AnnotationProviderFactory)SpiUtils.build(ctx, AnnotationProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            AnnotationProviderFactory.setAnnotationProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setAnnotationProviderFactory(ExternalContext ctx, AnnotationProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract AnnotationProvider createAnnotationProvider(ExternalContext var1);

    public AnnotationProvider getAnnotationProvider(ExternalContext externalContext) {
        return this.createAnnotationProvider(externalContext);
    }
}

