/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.html.HtmlOutputFormat;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;

public class HtmlFormatRenderer
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlFormatRenderer.class.getName());
    private static final Object[] EMPTY_ARGS = new Object[0];

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, UIOutput.class);
        String text = this.getOutputFormatText(facesContext, component);
        boolean escape = component instanceof HtmlOutputFormat ? ((HtmlOutputFormat)component).isEscape() : AttributeUtils.getBooleanAttribute(component, "escape", true);
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                long commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(component);
                if ((commonPropertiesMarked & 0xFFFFFFFFFFFFFFDFL) > 0L) {
                    span = true;
                    writer.startElement("span", component);
                    HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                } else if (CommonHtmlAttributesUtil.isIdRenderingNecessary(component)) {
                    span = true;
                    writer.startElement("span", component);
                    writer.writeAttribute("id", component.getClientId(facesContext), null);
                }
                CommonHtmlAttributesUtil.renderUniversalProperties(writer, commonPropertiesMarked, component);
                CommonHtmlAttributesUtil.renderStyleProperties(writer, commonPropertiesMarked, component);
            } else if (this.shouldRenderId(facesContext, component)) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeId(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText(text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    private String getOutputFormatText(FacesContext facesContext, UIComponent htmlOutputFormat) {
        List<UIParameter> validParams;
        String pattern = RendererUtils.getStringValue(facesContext, htmlOutputFormat);
        Object[] args = EMPTY_ARGS;
        if (htmlOutputFormat.getChildCount() > 0 && (validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, htmlOutputFormat.getChildren(), false, false, false)) != null && !validParams.isEmpty()) {
            ArrayList<Object> argsList = new ArrayList<Object>(validParams.size());
            int size = validParams.size();
            for (int i = 0; i < size; ++i) {
                UIParameter param = validParams.get(i);
                argsList.add(param.getValue());
            }
            args = argsList.toArray(new Object[argsList.size()]);
        }
        MessageFormat format = new MessageFormat(pattern, facesContext.getViewRoot().getLocale());
        try {
            return format.format(args);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error formatting message of component " + htmlOutputFormat.getClientId(facesContext) + " " + ComponentUtils.getPathToComponent(htmlOutputFormat));
            return "";
        }
    }
}

