/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.viewstate.StateCacheProviderImpl;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.StateCacheProvider;
import org.apache.myfaces.spi.StateCacheProviderFactory;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultStateCacheProviderFactory
extends StateCacheProviderFactory {
    public static final String STATE_CACHE_PROVIDER = StateCacheProvider.class.getName();
    public static final String STATE_CACHE_PROVIDER_LIST = StateCacheProvider.class.getName() + ".LIST";
    public static final String STATE_CACHE_PROVIDER_INSTANCE = StateCacheProvider.class.getName() + ".INSTANCE";

    private Logger getLogger() {
        return Logger.getLogger(DefaultStateCacheProviderFactory.class.getName());
    }

    @Override
    public StateCacheProvider getStateCacheProvider(ExternalContext externalContext) {
        return (StateCacheProvider)externalContext.getApplicationMap().computeIfAbsent(STATE_CACHE_PROVIDER_INSTANCE, k -> this.createStateCacheProvider(externalContext));
    }

    @Override
    public StateCacheProvider createStateCacheProvider(ExternalContext externalContext) {
        StateCacheProvider instance = null;
        try {
            instance = this.resolveStateCacheProviderFromService(externalContext);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        return instance;
    }

    private StateCacheProvider resolveStateCacheProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(STATE_CACHE_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(STATE_CACHE_PROVIDER);
            externalContext.getApplicationMap().put(STATE_CACHE_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(StateCacheProvider.class, classList, new StateCacheProviderImpl());
    }
}

