/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.lib.jsf.ConfigUtils;
import org.apache.myfaces.orchestra.lib.jsf.ContextLockRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.ConversationManagerRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.DataSourceLeakRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.ExternalContextUtils;
import org.apache.myfaces.orchestra.lib.jsf.FrameworkAdapterRequestHandler;
import org.apache.myfaces.orchestra.lib.jsf.PortletOrchestraFacesContextFactory;
import org.apache.myfaces.orchestra.lib.jsf.RequestHandler;
import org.apache.myfaces.orchestra.lib.jsf._FacesContextWrapper;

public class OrchestraFacesContextFactory
extends FacesContextFactory {
    private final Log log = LogFactory.getLog(OrchestraFacesContextFactory.class);
    private final FacesContextFactory original;
    private PortletOrchestraFacesContextFactory portletOrchestraFacesContextFactory;

    public OrchestraFacesContextFactory(FacesContextFactory original) {
        this.original = original;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        FacesContext facesContext;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"getFacesContext: entry");
        }
        if ((facesContext = this.original.getFacesContext(context, request, response, lifecycle)) == null) {
            return null;
        }
        if (!ExternalContextUtils.getRequestType(context, request).isPortlet()) {
            final LinkedList<RequestHandler> handlers = new LinkedList<RequestHandler>();
            handlers.add(new FrameworkAdapterRequestHandler());
            handlers.add(new ContextLockRequestHandler());
            handlers.add(new ConversationManagerRequestHandler());
            handlers.add(new DataSourceLeakRequestHandler());
            Map reqScope = facesContext.getExternalContext().getRequestMap();
            handlers.addAll(ConfigUtils.getRequestHandlers(reqScope));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"getFacesContext: creating custom instance");
            }
            return new _FacesContextWrapper(facesContext, false){
                {
                    super(x0, x1);
                    if (OrchestraFacesContextFactory.this.log.isDebugEnabled()) {
                        OrchestraFacesContextFactory.this.log.debug((Object)"getFacesContext: running inner constructor");
                    }
                    ListIterator i = handlers.listIterator();
                    try {
                        while (i.hasNext()) {
                            RequestHandler h = (RequestHandler)i.next();
                            if (OrchestraFacesContextFactory.this.log.isDebugEnabled()) {
                                OrchestraFacesContextFactory.this.log.debug((Object)("Running inithandler of type " + h.getClass().getName()));
                            }
                            h.init(facesContext);
                        }
                    }
                    catch (RuntimeException e) {
                        OrchestraFacesContextFactory.this.log.error((Object)"Problem initialising RequestHandler", (Throwable)e);
                        this._release(i);
                        throw e;
                    }
                }

                public void release() {
                    if (OrchestraFacesContextFactory.this.log.isDebugEnabled()) {
                        OrchestraFacesContextFactory.this.log.debug((Object)"Running release");
                    }
                    ListIterator i = handlers.listIterator();
                    while (i.hasNext()) {
                        i.next();
                    }
                    this._release(i);
                    if (OrchestraFacesContextFactory.this.log.isDebugEnabled()) {
                        OrchestraFacesContextFactory.this.log.debug((Object)"Release completed");
                    }
                    super.release();
                }

                private void _release(ListIterator i) {
                    while (i.hasPrevious()) {
                        try {
                            RequestHandler h = (RequestHandler)i.previous();
                            if (OrchestraFacesContextFactory.this.log.isDebugEnabled()) {
                                OrchestraFacesContextFactory.this.log.debug((Object)("Running deinithandler of type " + h.getClass().getName()));
                            }
                            h.deinit();
                        }
                        catch (Exception e) {
                            OrchestraFacesContextFactory.this.log.error((Object)"Problem deinitialising RequestHandler", (Throwable)e);
                        }
                    }
                }
            };
        }
        if (this.portletOrchestraFacesContextFactory == null) {
            this.portletOrchestraFacesContextFactory = new PortletOrchestraFacesContextFactory();
        }
        return this.portletOrchestraFacesContextFactory.getFacesContext(facesContext, context, request, response);
    }
}

