/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputUtils {
    public static List<String> parseStyleClassList(String styleClass) {
        if (styleClass == null) {
            return null;
        }
        int spaceIndex = styleClass.indexOf(32);
        if (spaceIndex < 0) {
            return null;
        }
        int prevSpaceIndex = 0;
        ArrayList<String> styleClasses = new ArrayList<String>();
        do {
            if (spaceIndex <= prevSpaceIndex) continue;
            styleClasses.add(styleClass.substring(prevSpaceIndex, spaceIndex));
        } while ((spaceIndex = styleClass.indexOf(32, prevSpaceIndex = spaceIndex + 1)) >= 0);
        if (prevSpaceIndex < styleClass.length()) {
            styleClasses.add(styleClass.substring(prevSpaceIndex));
        }
        return styleClasses;
    }

    public static String getOutputEncoding(FacesContext context) {
        return context.getResponseWriter().getCharacterEncoding();
    }

    public static void renderHiddenField(FacesContext context, String name, String value) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("input", null);
        rw.writeAttribute("type", (Object)"hidden", null);
        rw.writeAttribute("name", (Object)name, null);
        rw.writeAttribute("value", (Object)value, null);
        rw.endElement("input");
    }

    public static void renderLayoutTableAttributes(FacesContext context, RenderingContext arc, Object cellspacing, Object tableWidth) throws IOException {
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", cellspacing, tableWidth);
    }

    public static void renderLayoutTableAttributes(FacesContext context, RenderingContext arc, Object cellpadding, Object cellspacing, Object tableWidth) throws IOException {
        OutputUtils.renderLayoutTableAttributes(context, arc, cellpadding, cellspacing, "0", tableWidth);
    }

    public static void renderLayoutTableAttributes(FacesContext context, RenderingContext arc, Object cellpadding, Object cellspacing, Object border, Object tableWidth) throws IOException {
        OutputUtils._renderTableAttributes(context, arc, cellpadding, cellspacing, border, tableWidth, "");
        if (CoreRenderer.isScreenReaderMode((RenderingContext)arc)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("datatable", (Object)"0", null);
            writer.writeAttribute("role", (Object)"presentation", null);
        }
    }

    public static void renderLayoutTableAttributes(FacesContext context, RenderingContext arc, Object cellpadding, Object cellspacing, Object border, Object tableWidth, Object summary) throws IOException {
        OutputUtils.renderDataTableAttributes(context, arc, cellpadding, cellspacing, border, tableWidth, summary);
    }

    public static void renderDataTableAttributes(FacesContext context, RenderingContext arc, Object cellpadding, Object cellspacing, Object border, Object tableWidth, Object summary) throws IOException {
        OutputUtils._renderTableAttributes(context, arc, cellpadding, cellspacing, border, tableWidth, summary);
    }

    private static void _renderTableAttributes(FacesContext context, RenderingContext arc, Object cellpadding, Object cellspacing, Object border, Object tableWidth, Object summary) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("cellpadding", cellpadding, null);
        writer.writeAttribute("cellspacing", cellspacing, null);
        writer.writeAttribute("border", border, null);
        writer.writeAttribute("width", tableWidth, null);
        if (!XhtmlRenderer.isInaccessibleMode((RenderingContext)arc)) {
            writer.writeAttribute("summary", summary, null);
        }
    }

    public static void renderAltAndTooltipForImage(FacesContext context, RenderingContext afc, Object textValue) throws IOException {
        if (textValue == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean wroteTitle = false;
        if (!OutputUtils.supportsAltRendersTooltipOnImage(afc) && !"".equals(textValue)) {
            writer.writeAttribute("title", textValue, null);
            wroteTitle = true;
        }
        if (!wroteTitle || !XhtmlRenderer.isInaccessibleMode((RenderingContext)afc)) {
            writer.writeAttribute("alt", textValue, null);
        }
    }

    public static boolean supportsAltRendersTooltipOnImage(RenderingContext afc) {
        return Boolean.TRUE.equals(afc.getAgent().getCapabilities().get(TrinidadAgent.CAP_ALT_RENDERS_TOOLTIP_ON_IMAGE));
    }

    public static String getMiddleIconAlignment(RenderingContext arc) {
        return "middle";
    }

    public static void renderIcon(FacesContext context, RenderingContext arc, Icon icon, Object shortDesc, Object align) throws IOException {
        OutputUtils.renderIcon(context, arc, icon, shortDesc, align, false);
    }

    public static void renderIcon(FacesContext context, RenderingContext arc, Icon icon, Object shortDesc, Object align, boolean embedded) throws IOException {
        if (icon == null || icon.isNull()) {
            return;
        }
        ArrayMap attrs = null;
        if (shortDesc != null || align != null || embedded) {
            attrs = new ArrayMap(3);
            attrs.put("shortDesc", shortDesc);
            attrs.put("align", align);
            attrs.put("embedded", embedded);
        }
        icon.renderIcon(context, arc, (Map)attrs);
    }

    public static void renderImage(FacesContext context, RenderingContext arc, Object absoluteUri, Object width, Object height, Object id, Object altText) throws IOException {
        OutputUtils.renderImage(context, arc, absoluteUri, width, height, id, altText, null);
    }

    public static void renderImage(FacesContext context, RenderingContext arc, Object absoluteUri, Object width, Object height, Object id, Object altText, UIComponent comp) throws IOException {
        OutputUtils.renderImage(context, arc, absoluteUri, width, height, id, altText, comp, null, null);
    }

    public static void renderImage(FacesContext context, RenderingContext arc, Object absoluteUri, Object width, Object height, Object id, Object altText, UIComponent comp, String inlineStyle) throws IOException {
        OutputUtils.renderImage(context, arc, absoluteUri, width, height, id, altText, comp, inlineStyle, null);
    }

    public static void renderImage(FacesContext context, RenderingContext arc, Object absoluteUri, Object width, Object height, Object id, Object altText, UIComponent comp, String inlineStyle, String styleClass) throws IOException {
        if (absoluteUri == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", comp);
        writer.writeAttribute("id", id, null);
        absoluteUri = context.getExternalContext().encodeResourceURL(absoluteUri.toString());
        writer.writeURIAttribute("src", absoluteUri, null);
        OutputUtils.renderAltAndTooltipForImage(context, arc, altText);
        if (width != null) {
            writer.writeAttribute("width", width, null);
        }
        if (height != null) {
            writer.writeAttribute("height", height, null);
        }
        if (inlineStyle != null) {
            writer.writeAttribute("style", (Object)inlineStyle, null);
        }
        if (styleClass != null) {
            CoreRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styleClass);
        }
        writer.endElement("img");
    }

    public static Color getBackgroundColor(RenderingContext arc) {
        return Color.WHITE;
    }
}

