/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.RequestContextFactory;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidadinternal.config.GlobalConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.renderkit.RenderKitBase;

public abstract class RenderKitDecorator
extends RenderKitBase
implements Service.Provider {
    private static final String _RENDER_KIT_FACTORY_KEY = "org.apache.myfaces.trinidadinternal.renderkit.RenderKitDecorator.RENDER_KIT_FACTORY_KEY";

    public <T> T getService(Class<T> serviceClass) {
        return (T)Service.getService((Object)this.getRenderKit(), serviceClass);
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String encoding) {
        RenderKit renderKit = this.getRenderKit();
        ResponseWriter out = renderKit.createResponseWriter(writer, contentTypeList, encoding);
        return this.createDecoratedResponseWriter(out);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return this.getRenderKit().createResponseStream(out);
    }

    public ResponseStateManager getResponseStateManager() {
        return this.getRenderKit().getResponseStateManager();
    }

    public void addClientBehaviorRenderer(String type, ClientBehaviorRenderer renderer) {
        this.getRenderKit().addClientBehaviorRenderer(type, renderer);
    }

    public ClientBehaviorRenderer getClientBehaviorRenderer(String type) {
        return this.getRenderKit().getClientBehaviorRenderer(type);
    }

    public Iterator<String> getClientBehaviorRendererTypes() {
        return this.getRenderKit().getClientBehaviorRendererTypes();
    }

    protected ResponseWriter createDecoratedResponseWriter(ResponseWriter delegate) {
        return delegate;
    }

    @Override
    public Renderer findRenderer(String componentFamily, String rendererType) {
        RenderKit renderKit;
        Renderer renderer = super.findRenderer(componentFamily, rendererType);
        if (renderer == null && (renderer = (renderKit = this.getRenderKit()) instanceof RenderKitBase ? ((RenderKitBase)renderKit).findRenderer(componentFamily, rendererType) : renderKit.getRenderer(componentFamily, rendererType)) != null) {
            this.addRenderer(componentFamily, rendererType, renderer);
        }
        return renderer;
    }

    protected RenderKit getRenderKit() {
        RenderKitFactory oldFactory;
        ConcurrentMap appMap;
        RenderKitFactory factory;
        FacesContext context = FacesContext.getCurrentInstance();
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext == null) {
            ExternalContext externalContext = context.getExternalContext();
            GlobalConfiguratorImpl.getInstance().init(externalContext);
            requestContext = RequestContextFactory.getFactory().createContext(externalContext);
        }
        if ((factory = (RenderKitFactory)(appMap = requestContext.getApplicationScopedConcurrentMap()).get(_RENDER_KIT_FACTORY_KEY)) == null && (oldFactory = appMap.putIfAbsent(_RENDER_KIT_FACTORY_KEY, factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory"))) != null) {
            factory = oldFactory;
        }
        RenderKit renderKit = factory.getRenderKit(context, this.getDecoratedRenderKitId());
        assert (renderKit != null);
        return renderKit;
    }

    protected abstract String getDecoratedRenderKitId();
}

