/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.type;

import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.jumpto.EntityComparator;
import org.netbeans.modules.jumpto.common.DescriptorAccessor;
import org.netbeans.modules.jumpto.common.StateFullComparator;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.util.ChangeSupport;

public abstract class TypeComparator
extends EntityComparator<TypeDescriptor>
implements StateFullComparator<TypeDescriptor> {
    private final ChangeSupport support;
    protected final boolean caseSensitive;
    protected final boolean preferOpPrjs;

    private TypeComparator(boolean caseSensitive, boolean preferOpPrjs) {
        this.caseSensitive = caseSensitive;
        this.preferOpPrjs = preferOpPrjs;
        this.support = new ChangeSupport(this);
    }

    @Override
    public void addChangeListener(@NonNull ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(@NonNull ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    @Override
    public abstract int compare(TypeDescriptor var1, TypeDescriptor var2);

    abstract void setText(@NonNull String var1);

    protected void fireChange() {
        this.support.fireChange();
    }

    @NonNull
    public static TypeComparator create(@NonNull GoToSettings.SortingType kind, @NonNull String text, boolean caseSensitive, boolean preferOpPrjs) {
        switch (kind) {
            case LEVENSHTEIN: {
                return new Levenshtein(text, caseSensitive, preferOpPrjs);
            }
            case LEXICOGRAPHIC: {
                return new Alphabet(caseSensitive, preferOpPrjs);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)kind));
    }

    private static final class Alphabet
    extends TypeComparator {
        Alphabet(boolean caseSensitive, boolean preferOpPrjs) {
            super(caseSensitive, preferOpPrjs);
        }

        @Override
        void setText(@NonNull String text) {
        }

        @Override
        public int compare(TypeDescriptor e1, TypeDescriptor e2) {
            String e2projectName;
            String e1projectName;
            int result;
            if (this.preferOpPrjs && (result = this.compareProjects(e1projectName = e1.getProjectName(), e2projectName = e2.getProjectName())) != 0) {
                return result;
            }
            result = this.compare(e1.getTypeName(), e2.getTypeName(), this.caseSensitive);
            if (result != 0) {
                return result;
            }
            result = this.compare(e1.getOuterName(), e2.getOuterName());
            if (result != 0) {
                return result;
            }
            return this.compare(e1.getContextName(), e2.getContextName());
        }
    }

    private static final class Levenshtein
    extends TypeComparator {
        private static final String ATTR_PATTERN = "Pattern";
        private static final String ATTR_LS_DIST = "LevenshteinDistance";
        private static final String ATTR_LS_TAIL = "LevenshteinTail";
        protected String text;

        Levenshtein(@NonNull String text, boolean caseSensitive, boolean preferOpPrjs) {
            super(caseSensitive, preferOpPrjs);
            this.text = text;
        }

        @Override
        void setText(@NonNull String text) {
            boolean fire = !Objects.equals(this.text, text);
            this.text = text;
            if (fire) {
                this.fireChange();
            }
        }

        @Override
        public int compare(TypeDescriptor e1, TypeDescriptor e2) {
            int t2;
            int l2;
            String prefix;
            String tn;
            int t1;
            int l1;
            String e2projectName;
            String e1projectName;
            int result;
            if (this.preferOpPrjs && (result = this.compareProjects(e1projectName = e1.getProjectName(), e2projectName = e2.getProjectName())) != 0) {
                return result;
            }
            Object o = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_LS_DIST);
            Object t = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_LS_TAIL);
            Object p = DescriptorAccessor.getInstance().getAttribute(e1, ATTR_PATTERN);
            if (o instanceof Integer && t instanceof Integer && this.text.equals(p)) {
                l1 = (Integer)o;
                t1 = (Integer)t;
            } else {
                tn = e1.getSimpleName();
                prefix = this.levenshteinPrefix(tn, this.text, this.caseSensitive);
                l1 = this.levenshteinDistance(prefix, this.text, this.caseSensitive);
                t1 = tn.length() - prefix.length();
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_LS_DIST, l1);
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_LS_TAIL, t1);
                DescriptorAccessor.getInstance().setAttribute(e1, ATTR_PATTERN, this.text);
            }
            o = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_LS_DIST);
            t = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_LS_TAIL);
            p = DescriptorAccessor.getInstance().getAttribute(e2, ATTR_PATTERN);
            if (o instanceof Integer && t instanceof Integer && this.text.equals(p)) {
                l2 = (Integer)o;
                t2 = (Integer)t;
            } else {
                tn = e2.getSimpleName();
                prefix = this.levenshteinPrefix(tn, this.text, this.caseSensitive);
                l2 = this.levenshteinDistance(prefix, this.text, this.caseSensitive);
                t2 = tn.length() - prefix.length();
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_LS_DIST, l2);
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_LS_TAIL, t2);
                DescriptorAccessor.getInstance().setAttribute(e2, ATTR_PATTERN, this.text);
            }
            result = l1 - l2;
            if (result != 0) {
                return result;
            }
            result = t1 - t2;
            if (result != 0) {
                return result;
            }
            result = this.compare(e1.getTypeName(), e2.getTypeName(), this.caseSensitive);
            if (result != 0) {
                return result;
            }
            result = this.compare(e1.getOuterName(), e2.getOuterName());
            if (result != 0) {
                return result;
            }
            return this.compare(e1.getContextName(), e2.getContextName());
        }
    }
}

