/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * WhereUsedPanel.java
 *
 * Created on 5.2.2010, 10:18:47
 */

package org.netbeans.modules.html.editor.refactoring;

import java.awt.Component;
import org.netbeans.modules.html.editor.CssPreferences;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;

/**
 * Mosty a fake panel, no options needed so far
 *
 * <p>Copy of {@link org.netbeans.modules.css.refactoring.WhereUsedPanel}
 * to not add more API in CSS module or add circular dependency</p>
 *
 * @author mfukala@netbeans.org
 */
public class WhereUsedPanel extends javax.swing.JPanel implements CustomRefactoringPanel {

    /** Creates new form WhereUsedPanel */
    public WhereUsedPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        searchInCommentsCheckBox = new javax.swing.JCheckBox();
        findAllCheckBox = new javax.swing.JCheckBox();

        setPreferredSize(new java.awt.Dimension(200, 100));

        searchInCommentsCheckBox.setText(org.openide.util.NbBundle.getMessage(WhereUsedPanel.class, "WhereUsedPanel.searchInCommentsCheckBox.text")); // NOI18N
        searchInCommentsCheckBox.setEnabled(false);

        findAllCheckBox.setSelected(CssPreferences.findInUnrelatedFiles());
        findAllCheckBox.setText(org.openide.util.NbBundle.getMessage(WhereUsedPanel.class, "WhereUsedPanel.findAllCheckBox.text")); // NOI18N
        findAllCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findAllCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(searchInCommentsCheckBox)
                    .addComponent(findAllCheckBox))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(searchInCommentsCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(findAllCheckBox)
                .addContainerGap(37, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void findAllCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findAllCheckBoxActionPerformed
        CssPreferences.setFindInUnrelatedFiles(findAllCheckBox.isSelected());
    }//GEN-LAST:event_findAllCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox findAllCheckBox;
    private javax.swing.JCheckBox searchInCommentsCheckBox;
    // End of variables declaration//GEN-END:variables

    @Override
    public void initialize() {
        //no-op
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public boolean isFindAllOccurances() {
        return findAllCheckBox.isSelected();
    }

}
