/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class IntObjHashMap<V>
extends AbstractIntHashSet {
    private V[] values;

    public IntObjHashMap() {
        this(8);
    }

    public IntObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public IntObjHashMap(int initialCapacity, double loadFactor, int noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.values = new Object[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    public V get(int key) {
        return this.valueAt(this.keyIndex(key));
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int getNoEntryKey() {
        return -1;
    }

    public V[] getValues() {
        return this.values;
    }

    public void put(int key, V value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, int key, V value) {
        if (index < 0) {
            this.values[-index - 1] = value;
        } else {
            this.keys[index] = key;
            this.values[index] = value;
            if (--this.free == 0) {
                this.rehash();
            }
        }
    }

    public V valueAt(int index) {
        return index < 0 ? (V)this.valueAtQuick(index) : null;
    }

    public V valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        V[] oldValues = this.values;
        int[] oldKeys = this.keys;
        this.keys = new int[len];
        this.values = new Object[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            int key = oldKeys[i];
            if (key == this.noEntryKeyValue) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
        this.values[index] = null;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }
}

