/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.AbstractHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;

public class IntHashMap<V>
extends AbstractHashMap<Integer, V> {
    private Entry<V>[] table;
    private int capacity;
    private final float loadFactor;
    private int mask;

    public IntHashMap() {
        this(0);
    }

    public IntHashMap(int capacity) {
        this(capacity, 1.0f);
    }

    public IntHashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    public V get(int key) {
        Entry<V> e = this.getEntry(key);
        return (V)(e == null ? null : ((Entry)e).value);
    }

    @Override
    public V put(int key, V value) {
        Entry<V>[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry<V> e = table[index];
        while (e != null) {
            if (((Entry)e).key == key) {
                return e.setValue(value);
            }
            e = ((Entry)e).hashNext;
        }
        e = new Entry<V>(key, value);
        ((Entry)e).hashNext = (Entry)table[index];
        table[index] = e;
        ++this._size;
        if (this._size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return null;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    public V remove(int key) {
        Entry<V>[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        if (e == null) {
            return null;
        }
        if (e.key == key) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.key != key);
            last.hashNext = e.hashNext;
        }
        --this._size;
        return (V)e.value;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    @Override
    protected Map.Entry<Integer, V> getEntry(Object key) {
        return this.getEntry((Integer)key);
    }

    @Override
    protected void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.capacity = capacity;
        this._size = 0;
    }

    @Override
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    private Entry<V> getEntry(int key) {
        Entry<V>[] table = this.table;
        int index = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            if (e.key == key) {
                return e;
            }
            e = e.hashNext;
        }
        return null;
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            Iterator entries = this.entrySet().iterator();
            this.allocateTable(length);
            Entry<V>[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index = HashUtil.indexFor(e.key, length, mask);
                e.hashNext = (Entry)table[index];
                table[index] = e;
            }
        }
    }

    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        private final Entry<V>[] table;
        private int index;
        private Entry<V> e;
        private Entry<V> last;

        HashIterator() {
            super(IntHashMap.this);
            this.table = IntHashMap.this.table;
            this.index = 0;
            this.e = null;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            IntHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<V> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.initNextEntry();
            return result;
        }

        private void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.hashNext;
            }
            Entry<V>[] table = this.table;
            while (result == null && this.index < table.length) {
                result = table[this.index++];
            }
            this.e = result;
        }
    }

    private static class Entry<V>
    implements Map.Entry<Integer, V> {
        private final int key;
        private V value;
        private Entry<V> hashNext;

        private Entry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }
}

