/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db.migration;

import java.io.File;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.h2.jdbcx.JdbcConnectionPool;

public class LegacyDataSourceFactory {
    private static final String DB_USERNAME_PASSWORD = "nifireg";
    private static final int MAX_CONNECTIONS = 5;
    private static final String DATABASE_FILE_NAME = "nifi-registry";
    private final NiFiRegistryProperties properties;
    private JdbcConnectionPool connectionPool;

    public LegacyDataSourceFactory(NiFiRegistryProperties properties) {
        this.properties = properties;
    }

    public DataSource getDataSource() {
        if (this.connectionPool == null) {
            String databaseUrl = LegacyDataSourceFactory.getDatabaseUrl(this.properties);
            this.connectionPool = JdbcConnectionPool.create((String)databaseUrl, (String)DB_USERNAME_PASSWORD, (String)DB_USERNAME_PASSWORD);
            this.connectionPool.setMaxConnections(5);
        }
        return this.connectionPool;
    }

    public static String getDatabaseUrl(NiFiRegistryProperties properties) {
        String repositoryDirectoryPath = properties.getLegacyDatabaseDirectory();
        if (repositoryDirectoryPath == null) {
            throw new NullPointerException("Database directory must be specified.");
        }
        File repositoryDirectory = new File(repositoryDirectoryPath);
        File databaseFile = new File(repositoryDirectory, DATABASE_FILE_NAME);
        String databaseUrl = "jdbc:h2:" + databaseFile + ";AUTOCOMMIT=OFF;DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=3";
        String databaseUrlAppend = properties.getLegacyDatabaseUrlAppend();
        if (StringUtils.isNotBlank((CharSequence)databaseUrlAppend)) {
            databaseUrl = databaseUrl + databaseUrlAppend;
        }
        return databaseUrl;
    }
}

