/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.services.kms.model.GrantOperation;
import software.amazon.awssdk.services.kms.model.GrantOperationListCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGrantRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, CreateGrantRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(CreateGrantRequest.getter(CreateGrantRequest::keyId)).setter(CreateGrantRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> GRANTEE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteePrincipal").getter(CreateGrantRequest.getter(CreateGrantRequest::granteePrincipal)).setter(CreateGrantRequest.setter(Builder::granteePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteePrincipal").build()}).build();
    private static final SdkField<String> RETIRING_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetiringPrincipal").getter(CreateGrantRequest.getter(CreateGrantRequest::retiringPrincipal)).setter(CreateGrantRequest.setter(Builder::retiringPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetiringPrincipal").build()}).build();
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(CreateGrantRequest.getter(CreateGrantRequest::operationsAsStrings)).setter(CreateGrantRequest.setter(Builder::operationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GrantConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constraints").getter(CreateGrantRequest.getter(CreateGrantRequest::constraints)).setter(CreateGrantRequest.setter(Builder::constraints)).constructor(GrantConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(CreateGrantRequest.getter(CreateGrantRequest::grantTokens)).setter(CreateGrantRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateGrantRequest.getter(CreateGrantRequest::name)).setter(CreateGrantRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateGrantRequest.getter(CreateGrantRequest::dryRun)).setter(CreateGrantRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, GRANTEE_PRINCIPAL_FIELD, RETIRING_PRINCIPAL_FIELD, OPERATIONS_FIELD, CONSTRAINTS_FIELD, GRANT_TOKENS_FIELD, NAME_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyId", KEY_ID_FIELD);
            this.put("GranteePrincipal", GRANTEE_PRINCIPAL_FIELD);
            this.put("RetiringPrincipal", RETIRING_PRINCIPAL_FIELD);
            this.put("Operations", OPERATIONS_FIELD);
            this.put("Constraints", CONSTRAINTS_FIELD);
            this.put("GrantTokens", GRANT_TOKENS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String keyId;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final List<String> operations;
    private final GrantConstraints constraints;
    private final List<String> grantTokens;
    private final String name;
    private final Boolean dryRun;

    private CreateGrantRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
        this.grantTokens = builder.grantTokens;
        this.name = builder.name;
        this.dryRun = builder.dryRun;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String granteePrincipal() {
        return this.granteePrincipal;
    }

    public final String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public final List<GrantOperation> operations() {
        return GrantOperationListCopier.copyStringToEnum(this.operations);
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<String> operationsAsStrings() {
        return this.operations;
    }

    public final GrantConstraints constraints() {
        return this.constraints;
    }

    public final boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public final List<String> grantTokens() {
        return this.grantTokens;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.retiringPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.granteePrincipal(), other.granteePrincipal()) && Objects.equals(this.retiringPrincipal(), other.retiringPrincipal()) && this.hasOperations() == other.hasOperations() && Objects.equals(this.operationsAsStrings(), other.operationsAsStrings()) && Objects.equals(this.constraints(), other.constraints()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGrantRequest").add("KeyId", (Object)this.keyId()).add("GranteePrincipal", (Object)this.granteePrincipal()).add("RetiringPrincipal", (Object)this.retiringPrincipal()).add("Operations", this.hasOperations() ? this.operationsAsStrings() : null).add("Constraints", (Object)this.constraints()).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("Name", (Object)this.name()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "GranteePrincipal": {
                return Optional.ofNullable(clazz.cast(this.granteePrincipal()));
            }
            case "RetiringPrincipal": {
                return Optional.ofNullable(clazz.cast(this.retiringPrincipal()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operationsAsStrings()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantRequest, T> g) {
        return obj -> g.apply((CreateGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String granteePrincipal;
        private String retiringPrincipal;
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private GrantConstraints constraints;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.operationsWithStrings(model.operations);
            this.constraints(model.constraints);
            this.grantTokens(model.grantTokens);
            this.name(model.name);
            this.dryRun(model.dryRun);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final Collection<String> getOperations() {
            if (this.operations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String ... operations) {
            this.operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<GrantOperation> operations) {
            this.operations = GrantOperationListCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(GrantOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final GrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(GrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGrantRequest build() {
            return new CreateGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGrantRequest> {
        public Builder keyId(String var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder operationsWithStrings(Collection<String> var1);

        public Builder operationsWithStrings(String ... var1);

        public Builder operations(Collection<GrantOperation> var1);

        public Builder operations(GrantOperation ... var1);

        public Builder constraints(GrantConstraints var1);

        default public Builder constraints(Consumer<GrantConstraints.Builder> constraints) {
            return this.constraints((GrantConstraints)((GrantConstraints.Builder)GrantConstraints.builder().applyMutation(constraints)).build());
        }

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder name(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

