/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultConfigurationException;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultConfiguration;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultProperties;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.Plaintext;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.vault.support.VaultResponseSupport;

public class StandardHashiCorpVaultCommunicationService
implements HashiCorpVaultCommunicationService {
    private final VaultTemplate vaultTemplate;
    private final VaultTransitOperations transitOperations;
    private final Map<String, VaultKeyValueOperations> keyValueOperationsMap;
    private final VaultKeyValueOperationsSupport.KeyValueBackend keyValueBackend;

    public StandardHashiCorpVaultCommunicationService(PropertySource<?> ... propertySources) throws HashiCorpVaultConfigurationException {
        HashiCorpVaultConfiguration vaultConfiguration = new HashiCorpVaultConfiguration(propertySources);
        this.vaultTemplate = new VaultTemplate(vaultConfiguration.vaultEndpoint(), ClientHttpRequestFactoryFactory.create((ClientOptions)vaultConfiguration.clientOptions(), (SslConfiguration)vaultConfiguration.sslConfiguration()), (SessionManager)new SimpleSessionManager(vaultConfiguration.clientAuthentication()));
        this.transitOperations = this.vaultTemplate.opsForTransit();
        this.keyValueBackend = vaultConfiguration.getKeyValueBackend();
        this.keyValueOperationsMap = new HashMap<String, VaultKeyValueOperations>();
    }

    public String getServerVersion() {
        return this.vaultTemplate.opsForSys().health().getVersion();
    }

    public StandardHashiCorpVaultCommunicationService(HashiCorpVaultProperties vaultProperties) throws HashiCorpVaultConfigurationException {
        this(new HashiCorpVaultPropertySource(vaultProperties));
    }

    public String encrypt(String transitPath, byte[] plainText) {
        return this.transitOperations.encrypt(transitPath, Plaintext.of((byte[])plainText)).getCiphertext();
    }

    public byte[] decrypt(String transitPath, String cipherText) {
        return this.transitOperations.decrypt(transitPath, Ciphertext.of((String)cipherText)).getPlaintext();
    }

    public void writeKeyValueSecret(String keyValuePath, String secretKey, String value) {
        Objects.requireNonNull(keyValuePath, "Vault K/V path must be specified");
        Objects.requireNonNull(secretKey, "Secret secretKey must be specified");
        Objects.requireNonNull(value, "Secret value must be specified");
        VaultKeyValueOperations keyValueOperations = this.keyValueOperationsMap.computeIfAbsent(keyValuePath, path -> this.vaultTemplate.opsForKeyValue(path, this.keyValueBackend));
        keyValueOperations.put(secretKey, (Object)new SecretData(value));
    }

    public Optional<String> readKeyValueSecret(String keyValuePath, String secretKey) {
        Objects.requireNonNull(keyValuePath, "Vault K/V path must be specified");
        Objects.requireNonNull(secretKey, "Secret secretKey must be specified");
        VaultKeyValueOperations keyValueOperations = this.keyValueOperationsMap.computeIfAbsent(keyValuePath, path -> this.vaultTemplate.opsForKeyValue(path, this.keyValueBackend));
        VaultResponseSupport response = keyValueOperations.get(secretKey, SecretData.class);
        return response == null ? Optional.empty() : Optional.ofNullable(((SecretData)response.getRequiredData()).getValue());
    }

    public void writeKeyValueSecretMap(String keyValuePath, String secretKey, Map<String, String> keyValues) {
        Objects.requireNonNull(keyValuePath, "Vault K/V path must be specified");
        Objects.requireNonNull(secretKey, "Secret secretKey must be specified");
        Objects.requireNonNull(keyValues, "Key/values map must be specified");
        if (keyValues.isEmpty()) {
            return;
        }
        VaultKeyValueOperations keyValueOperations = this.keyValueOperationsMap.computeIfAbsent(keyValuePath, path -> this.vaultTemplate.opsForKeyValue(path, this.keyValueBackend));
        keyValueOperations.put(secretKey, keyValues);
    }

    public Map<String, String> readKeyValueSecretMap(String keyValuePath, String key) {
        VaultKeyValueOperations keyValueOperations = this.keyValueOperationsMap.computeIfAbsent(keyValuePath, path -> this.vaultTemplate.opsForKeyValue(path, this.keyValueBackend));
        VaultResponseSupport response = keyValueOperations.get(key, Map.class);
        return response == null ? Collections.emptyMap() : (Map)response.getRequiredData();
    }

    public List<String> listKeyValueSecrets(String keyValuePath) {
        VaultKeyValueOperations keyValueOperations = this.keyValueOperationsMap.computeIfAbsent(keyValuePath, path -> this.vaultTemplate.opsForKeyValue(path, VaultKeyValueOperationsSupport.KeyValueBackend.KV_1));
        return keyValueOperations.list("/");
    }

    private static class SecretData {
        private final String value;

        @JsonCreator
        public SecretData(@JsonProperty(value="value") String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

