/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.persistent.PersistentBitTreeLongSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdArrayCachedInstanceIterableFactory;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.OrderedEntityIdCollection;
import jetbrains.exodus.entitystore.iterate.UpdatableCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.iterator.OrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseOrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatableEntityIdSortedSetCachedInstanceIterable
extends UpdatableCachedInstanceIterable {
    private static final PersistentLongSet EMPTY_IDS = new PersistentBitTreeLongSet();
    private final int entityTypeId;
    @NotNull
    private final PersistentLongSet localIds;
    @Nullable
    private PersistentLongSet.MutableSet mutableLocalIds;
    @Nullable
    private EntityIdSet idSet;
    @Nullable
    private OrderedEntityIdCollection idCollection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatableEntityIdSortedSetCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn, source);
        this.entityTypeId = source.getEntityTypeId();
        EntityIteratorBase it = (EntityIteratorBase)source.getIteratorImpl(txn);
        try {
            if (!it.hasNext()) {
                this.localIds = EMPTY_IDS;
            } else {
                this.localIds = EMPTY_IDS.getClone();
                PersistentLongSet.MutableSet mutableLocalIds = this.localIds.beginWrite();
                do {
                    EntityId entityId;
                    if ((entityId = it.nextId()) == null) {
                        throw new NullPointerException("EntityIteratorBase.nextId() returned null!");
                    }
                    mutableLocalIds.add(entityId.getLocalId());
                } while (it.hasNext());
                mutableLocalIds.endWrite();
            }
        }
        finally {
            it.disposeIfShouldBe();
        }
        this.mutableLocalIds = null;
        this.idSet = null;
        this.idCollection = null;
    }

    protected UpdatableEntityIdSortedSetCachedInstanceIterable(@NotNull UpdatableEntityIdSortedSetCachedInstanceIterable source) {
        super(source.getTransaction(), source);
        this.entityTypeId = source.entityTypeId;
        this.localIds = source.localIds.getClone();
        this.mutableLocalIds = this.localIds.beginWrite();
        this.idSet = null;
        this.idCollection = null;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return this.getIterator(false);
    }

    @Override
    @NotNull
    public EntityIterator getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return this.getIterator(true);
    }

    @Override
    public long size() {
        return this.getCurrentMap().size();
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        if (this.idSet == null) {
            OrderedEntityIdCollection idCollection;
            boolean isImmutable;
            boolean bl = isImmutable = this.mutableLocalIds == null;
            if (isImmutable && (idCollection = this.getOrCreateIdCollection()) instanceof EntityIdSet) {
                EntityIdSet result;
                this.idSet = result = (EntityIdSet)idCollection;
                return result;
            }
            EntityIterator it = this.getIteratorImpl(txn);
            EntityIdSet result = EntityIdSetFactory.newSet();
            while (it.hasNext()) {
                result = result.add(it.nextId());
            }
            if (!isImmutable) {
                return result;
            }
            this.idSet = result;
            return result;
        }
        return this.idSet;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.size();
    }

    @Override
    protected boolean containsImpl(@NotNull EntityId entityId) {
        EntityIdSet ids = this.idSet;
        if (ids != null) {
            return ids.contains(entityId);
        }
        return super.containsImpl(entityId);
    }

    @Override
    public UpdatableEntityIdSortedSetCachedInstanceIterable beginUpdate() {
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(this);
    }

    @Override
    public boolean isMutated() {
        return this.mutableLocalIds != null;
    }

    @Override
    public void endUpdate() {
        this.checkMutableIds().endWrite();
        this.mutableLocalIds = null;
    }

    final void addEntity(EntityId id) {
        this.checkEntityType(id);
        this.checkMutableIds().add(id.getLocalId());
    }

    final void removeEntity(EntityId id) {
        this.checkEntityType(id);
        this.checkMutableIds().remove(id.getLocalId());
    }

    @NotNull
    private OrderedEntityIdCollection getOrCreateIdCollection() {
        OrderedEntityIdCollection collection = this.idCollection;
        if (collection == null) {
            PersistentLongSet.ImmutableSet currentSet = this.localIds.beginRead();
            long[] result = new long[currentSet.size()];
            LongIterator it = currentSet.longIterator();
            int i = 0;
            while (it.hasNext()) {
                result[i++] = (Long)it.next();
            }
            this.idCollection = collection = EntityIdArrayCachedInstanceIterableFactory.makeIdCollection(this.entityTypeId, result);
        }
        return collection;
    }

    private PersistentLongSet.ImmutableSet getCurrentMap() {
        return this.mutableLocalIds == null ? this.localIds.beginRead() : this.mutableLocalIds;
    }

    private PersistentLongSet.MutableSet checkMutableIds() {
        PersistentLongSet.MutableSet mutableLocalIds = this.mutableLocalIds;
        if (mutableLocalIds == null) {
            throw new IllegalStateException("UpdatableEntityIdSortedSetCachedInstanceIterable was not mutated");
        }
        return mutableLocalIds;
    }

    private void checkEntityType(EntityId id) {
        if (id.getTypeId() != this.entityTypeId) {
            throw new IllegalStateException("Unexpected entity type id: " + id.getTypeId());
        }
    }

    @NotNull
    private EntityIterator getIterator(final boolean reverse) {
        if (this.localIds == EMPTY_IDS && this.mutableLocalIds == null) {
            return EntityIteratorBase.EMPTY;
        }
        final PersistentLongSet.MutableSet mutableSet = this.mutableLocalIds;
        if (mutableSet == null) {
            return reverse ? new ReverseOrderedEntityIdCollectionIterator(this, this.getOrCreateIdCollection()) : new OrderedEntityIdCollectionIterator(this, this.getOrCreateIdCollection());
        }
        return new NonDisposableEntityIterator(this){
            private final LongIterator it;
            {
                super(iterable2);
                this.it = reverse ? mutableSet.reverseLongIterator() : mutableSet.longIterator();
            }

            @Override
            protected boolean hasNextImpl() {
                return this.it.hasNext();
            }

            @Override
            @Nullable
            protected EntityId nextIdImpl() {
                return new PersistentEntityId(UpdatableEntityIdSortedSetCachedInstanceIterable.this.entityTypeId, (Long)this.it.next());
            }
        };
    }
}

