/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.revocation;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.jwt.revocation.JwtLogoutListener;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

public class StandardJwtLogoutListener
implements JwtLogoutListener {
    private final JwtDecoder jwtDecoder;
    private final JwtRevocationService jwtRevocationService;

    public StandardJwtLogoutListener(JwtDecoder jwtDecoder, JwtRevocationService jwtRevocationService) {
        this.jwtDecoder = jwtDecoder;
        this.jwtRevocationService = jwtRevocationService;
    }

    @Override
    public void logout(String bearerToken) {
        if (StringUtils.isNotBlank((CharSequence)bearerToken)) {
            Jwt jwt = this.jwtDecoder.decode(bearerToken);
            this.jwtRevocationService.setRevoked(jwt.getId(), jwt.getExpiresAt());
        }
    }
}

