/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathBaseEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathEvaluator
extends JsonPathBaseEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathEvaluator.class);

    public JsonPathEvaluator(Evaluator<String> subject, Evaluator<String> jsonPathExp) {
        super(subject, jsonPathExp);
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext context) {
        DocumentContext documentContext = this.getDocumentContext(context);
        JsonPath compiledJsonPath = this.getJsonPath(context);
        Object result = null;
        try {
            result = documentContext.read(compiledJsonPath);
        }
        catch (PathNotFoundException pnf) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("PathNotFoundException for JsonPath {}", (Object)compiledJsonPath.getPath(), (Object)pnf);
            }
            return EMPTY_RESULT;
        }
        catch (Exception e) {
            LOGGER.error("Exception while reading JsonPath {}", (Object)compiledJsonPath.getPath(), (Object)e);
            return EMPTY_RESULT;
        }
        return new StringQueryResult(JsonPathEvaluator.getResultRepresentation(result, EMPTY_RESULT.getValue()));
    }
}

