/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.persistence.metamodel.StaticMetamodel;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.meta.CompileTimeLogger;
import org.apache.openjpa.persistence.meta.SourceAnnotationHandler;
import org.apache.openjpa.persistence.util.SourceCode;

@SupportedAnnotationTypes(value={"javax.persistence.Entity", "javax.persistence.Embeddable", "javax.persistence.MappedSuperclass"})
@SupportedOptions(value={"openjpa.log", "openjpa.source", "openjpa.naming", "openjpa.header", "openjpa.metamodel", "openjpa.addGeneratedAnnotation"})
public class AnnotationProcessor6
extends AbstractProcessor {
    private SourceAnnotationHandler handler;
    private MetaDataFactory factory;
    private int generatedSourceVersion = 6;
    private CompileTimeLogger logger;
    private List<String> header = new ArrayList<String>();
    private boolean active;
    private static Localizer _loc = Localizer.forPackage(AnnotationProcessor6.class);
    private SourceVersion supportedSourceVersion;
    private String addGeneratedOption;
    private Class<?> generatedAnnotation;
    private Date generationDate;
    private static List<String> CLASSNAMES_LIST = Arrays.asList("java.util.List", "java.util.AbstractList", "java.util.AbstractSequentialList", "java.util.ArrayList", "java.util.Stack", "java.util.Vector");
    private static List<String> CLASSNAMES_SET = Arrays.asList("java.util.Set", "java.util.AbstractSet", "java.util.EnumSet", "java.util.HashSet", "java.util.LinkedList", "java.util.LinkedHashSet", "java.util.SortedSet", "java.util.TreeSet");
    private static List<String> CLASSNAMES_MAP = Arrays.asList("java.util.Map", "java.util.AbstractMap", "java.util.EnumMap", "java.util.HashMap", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.Properties", "java.util.SortedMap", "java.util.TreeMap");
    private static List<String> CLASSNAMES_COLLECTION = Arrays.asList("java.util.Collection", "java.util.AbstractCollection", "java.util.AbstractQueue", "java.util.Queue", "java.util.PriorityQueue");

    private TypeCategory toMetaModelTypeCategory(TypeMirror mirror, String name, boolean persistentCollection) {
        if (mirror.getKind() == TypeKind.ARRAY && persistentCollection) {
            return TypeCategory.LIST;
        }
        if (CLASSNAMES_COLLECTION.contains(name)) {
            return TypeCategory.COLLECTION;
        }
        if (CLASSNAMES_LIST.contains(name)) {
            return TypeCategory.LIST;
        }
        if (CLASSNAMES_SET.contains(name)) {
            return TypeCategory.SET;
        }
        if (CLASSNAMES_MAP.contains(name)) {
            return TypeCategory.MAP;
        }
        return TypeCategory.ATTRIBUTE;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        if (this.supportedSourceVersion != null) {
            return this.supportedSourceVersion;
        }
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.active = "true".equalsIgnoreCase(this.getOptionValue("openjpa.metamodel"));
        if (!this.active) {
            return;
        }
        String supported = this.getOptionValue("openjpa.processor.supportedversion");
        this.supportedSourceVersion = supported != null ? SourceVersion.valueOf(supported) : SourceVersion.latestSupported();
        processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, _loc.get("mmg-tool-banner").toString());
        this.logger = new CompileTimeLogger(processingEnv, this.getOptionValue("openjpa.log"));
        this.setSourceVersion();
        this.setNamingPolicy();
        this.setHeader();
        this.handler = new SourceAnnotationHandler(processingEnv, this.logger);
        this.setAddGeneratedAnnotation();
        this.generationDate = new Date();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annos, RoundEnvironment roundEnv) {
        if (this.active && !roundEnv.processingOver()) {
            Set<? extends Element> elements = roundEnv.getRootElements();
            for (Element element : elements) {
                if (!(element instanceof TypeElement)) continue;
                this.process((TypeElement)element);
            }
        }
        return true;
    }

    private boolean process(TypeElement e) {
        if (!this.handler.isAnnotatedAsEntity(e)) {
            return false;
        }
        Elements eUtils = this.processingEnv.getElementUtils();
        String originalClass = eUtils.getBinaryName(e).toString();
        String originalSimpleClass = e.getSimpleName().toString();
        String metaClass = this.factory.getMetaModelClassName(originalClass);
        SourceCode source = new SourceCode(metaClass);
        this.comment(source);
        this.annotate(source, originalClass);
        TypeElement supCls = this.handler.getPersistentSupertype(e);
        if (supCls != null) {
            String superName = this.factory.getMetaModelClassName(supCls.toString());
            source.getTopLevelClass().setSuper(superName);
        }
        try {
            PrintWriter writer = this.createSourceFile(originalClass, metaClass, e);
            SourceCode.Class modelClass = source.getTopLevelClass();
            Set<Element> members = this.handler.getPersistentMembers(e);
            for (Element m : members) {
                boolean isPersistentCollection = m.getAnnotation(PersistentCollection.class) != null;
                TypeMirror decl = this.handler.getDeclaredType(m);
                String fieldName = this.handler.getPersistentMemberName(m);
                String fieldType = this.handler.getDeclaredTypeName(decl, true, isPersistentCollection);
                TypeCategory typeCategory = this.toMetaModelTypeCategory(decl, fieldType, isPersistentCollection);
                String metaModelType = typeCategory.getMetaModelType();
                SourceCode.Element modelField = null;
                switch (typeCategory) {
                    case ATTRIBUTE: {
                        modelField = modelClass.addField(fieldName, metaModelType);
                        modelField.addParameter(originalSimpleClass).addParameter(fieldType);
                        break;
                    }
                    case COLLECTION: 
                    case LIST: 
                    case SET: {
                        TypeMirror param = this.handler.getTypeParameter(m, decl, 0, true);
                        String elementType = this.handler.getDeclaredTypeName(param);
                        modelField = modelClass.addField(fieldName, metaModelType);
                        modelField.addParameter(originalSimpleClass).addParameter(elementType);
                        break;
                    }
                    case MAP: {
                        TypeMirror key = this.handler.getTypeParameter(m, decl, 0, false);
                        TypeMirror value = this.handler.getTypeParameter(m, decl, 1, true);
                        String keyType = this.handler.getDeclaredTypeName(key);
                        String valueType = this.handler.getDeclaredTypeName(value);
                        modelField = modelClass.addField(fieldName, metaModelType);
                        modelField.addParameter(originalSimpleClass).addParameter(keyType).addParameter(valueType);
                    }
                }
                ((SourceCode.Field)((SourceCode.Field)modelField.makePublic()).makeStatic()).makeVolatile();
            }
            source.write(writer);
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e1) {
            this.logger.error(_loc.get("mmg-process-error", e.getQualifiedName()), e1);
            return false;
        }
    }

    private void annotate(SourceCode source, String originalClass) {
        SourceCode.Class cls = source.getTopLevelClass();
        cls.addAnnotation(StaticMetamodel.class.getName()).addArgument("value", originalClass + ".class", false);
        switch (this.addGeneratedOption) {
            case "false": {
                return;
            }
            case "force": {
                cls.addAnnotation(Generated.class.getName()).addArgument("value", this.getClass().getName()).addArgument("date", this.generationDate.toString());
                break;
            }
            default: {
                if (this.generatedAnnotation == null || this.generatedSourceVersion < 6) break;
                cls.addAnnotation(this.generatedAnnotation.getName()).addArgument("value", this.getClass().getName()).addArgument("date", this.generationDate.toString());
            }
        }
    }

    private void comment(SourceCode source) {
        if (this.header.size() != 0) {
            source.addComment(false, this.header.toArray(new String[this.header.size()]));
        }
        String defaultHeader = _loc.get("mmg-tool-sign").getMessage();
        source.addComment(false, defaultHeader);
    }

    private void setSourceVersion() {
        String version = this.getOptionValue("openjpa.source");
        if (version != null) {
            try {
                this.generatedSourceVersion = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                this.logger.warn(_loc.get("mmg-bad-source", version, 6));
                this.generatedSourceVersion = 6;
            }
        } else {
            this.generatedSourceVersion = 6;
        }
    }

    private void setNamingPolicy() {
        String policy = this.getOptionValue("openjpa.naming");
        if (policy != null) {
            try {
                this.factory = (MetaDataFactory)Class.forName(policy).newInstance();
            }
            catch (Throwable e) {
                this.logger.warn(_loc.get("mmg-bad-naming", policy, e));
                this.factory = new PersistenceMetaDataFactory();
            }
        } else {
            this.factory = new PersistenceMetaDataFactory();
        }
    }

    private void setHeader() {
        String headerOption = this.getOptionValue("openjpa.header");
        if (headerOption == null) {
            return;
        }
        if ("ASL".equalsIgnoreCase(headerOption)) {
            this.header.add(_loc.get("mmg-asl-header").getMessage());
        } else {
            try {
                URL url = new URL(headerOption);
                InputStream is = url.openStream();
                Scanner s = new Scanner(is);
                while (s.hasNextLine()) {
                    this.header.add(s.nextLine());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void setAddGeneratedAnnotation() {
        this.addGeneratedOption = this.getOptionValue("openjpa.addGeneratedAnnotation");
        if (this.addGeneratedOption == null) {
            this.addGeneratedOption = "auto";
        }
        try {
            this.generatedAnnotation = Class.forName("javax.annotation.Generated", false, null);
        }
        catch (ClassNotFoundException generatedNotFoundEx) {
            this.logger.trace(_loc.get("mmg-annotation-not-found"));
        }
    }

    private PrintWriter createSourceFile(String originalClass, String metaClass, TypeElement e) throws IOException {
        JavaFileObject javaFile = this.processingEnv.getFiler().createSourceFile(metaClass, e);
        this.logger.info(_loc.get("mmg-process", javaFile.toUri().normalize()));
        return new PrintWriter(javaFile.openWriter());
    }

    private String getOptionValue(String ... keys) {
        Map<String, String> options = this.processingEnv.getOptions();
        for (String key : keys) {
            if (!options.containsKey(key)) continue;
            return options.get(key);
        }
        return null;
    }

    private static enum TypeCategory {
        ATTRIBUTE("javax.persistence.metamodel.SingularAttribute"),
        COLLECTION("javax.persistence.metamodel.CollectionAttribute"),
        SET("javax.persistence.metamodel.SetAttribute"),
        LIST("javax.persistence.metamodel.ListAttribute"),
        MAP("javax.persistence.metamodel.MapAttribute");

        private String type;

        private TypeCategory(String type) {
            this.type = type;
        }

        public String getMetaModelType() {
            return this.type;
        }
    }
}

