/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;
import org.apache.openjpa.lib.util.StringUtil;

public class JPAProperties {
    private static final String REGEX_DOT = "\\.";
    public static final String PREFIX = "jakarta.persistence.";
    public static final String PROVIDER = "jakarta.persistence.provider";
    public static final String TRANSACTION_TYPE = "jakarta.persistence.transactionType";
    public static final String DATASOURCE = "jakarta.persistence.dataSource";
    public static final String DATASOURCE_JTA = "jakarta.persistence.jtaDataSource";
    public static final String DATASOURCE_NONJTA = "jakarta.persistence.nonJtaDataSource";
    public static final String JDBC_DRIVER = "jakarta.persistence.jdbc.driver";
    public static final String JDBC_URL = "jakarta.persistence.jdbc.url";
    public static final String JDBC_USER = "jakarta.persistence.jdbc.user";
    public static final String JDBC_PASSWORD = "jakarta.persistence.jdbc.password";
    public static final String LOCK_SCOPE = "jakarta.persistence.lock.scope";
    public static final String LOCK_TIMEOUT = "jakarta.persistence.lock.timeout";
    public static final String QUERY_TIMEOUT = "jakarta.persistence.query.timeout";
    public static final String CACHE_MODE = "jakarta.persistence.sharedCache.mode";
    public static final String CACHE_STORE_MODE = "jakarta.persistence.cache.storeMode";
    public static final String CACHE_RETRIEVE_MODE = "jakarta.persistence.cache.retrieveMode";
    public static final String VALIDATE_FACTORY = "jakarta.persistence.validation.factory";
    public static final String VALIDATE_MODE = "jakarta.persistence.validation.mode";
    public static final String VALIDATE_PRE_PERSIST = "jakarta.persistence.validation.group.pre-persist";
    public static final String VALIDATE_PRE_REMOVE = "jakarta.persistence.validation.group.pre-remove";
    public static final String VALIDATE_PRE_UPDATE = "jakarta.persistence.validation.group.pre-update";
    public static final String VALIDATE_GROUP_DEFAULT = "jakarta.validation.groups.Default";
    private static Map<String, String> _names = new HashMap<String, String>();

    static void record(String kernel, String user) {
        _names.put(kernel, user);
    }

    static String getUserName(String beanProperty) {
        return _names.getOrDefault(beanProperty, beanProperty);
    }

    public static boolean isValidKey(String key) {
        return key != null && key.startsWith(PREFIX);
    }

    public static String getBeanProperty(String key) {
        if (!JPAProperties.isValidKey(key)) {
            throw new IllegalArgumentException("Invalid JPA property " + key);
        }
        String[] parts = key.split(REGEX_DOT);
        StringBuilder buf = new StringBuilder();
        for (int i = 2; i < parts.length; ++i) {
            buf.append(StringUtil.capitalize(parts[i]));
        }
        return buf.toString();
    }

    public static <T> T convertToKernelValue(Class<T> resultType, String key, Object value) {
        if (value == null) {
            return null;
        }
        if (JPAProperties.isValidKey(key)) {
            if (value instanceof CacheRetrieveMode || value instanceof String && CACHE_RETRIEVE_MODE.equals(key)) {
                return (T)((Object)DataCacheRetrieveMode.valueOf(value.toString().trim().toUpperCase(Locale.ENGLISH)));
            }
            if (value instanceof CacheStoreMode || value instanceof String && CACHE_STORE_MODE.equals(key)) {
                return (T)((Object)DataCacheStoreMode.valueOf(value.toString().trim().toUpperCase(Locale.ENGLISH)));
            }
            if (resultType != null && !resultType.isAssignableFrom(value.getClass()) && value instanceof String) {
                if ("null".equals(value)) {
                    return null;
                }
                return StringUtil.parse((String)value, resultType);
            }
        }
        return (T)value;
    }

    public static Object convertToUserValue(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (JPAProperties.isValidKey(key)) {
            if (value instanceof DataCacheRetrieveMode) {
                return CacheRetrieveMode.valueOf(value.toString().trim().toUpperCase(Locale.ENGLISH));
            }
            if (value instanceof DataCacheStoreMode) {
                return CacheStoreMode.valueOf(value.toString().trim().toUpperCase(Locale.ENGLISH));
            }
        }
        return value;
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, String key, Map<String, Object> prop) {
        return (E)JPAProperties.getEnumValue(type, null, (String)key, prop);
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, E[] values, String key, Map<String, Object> prop) {
        if (prop == null) {
            return null;
        }
        return (E)JPAProperties.getEnumValue(type, values, (Object)prop.get(key));
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, Object val) {
        return (E)JPAProperties.getEnumValue(type, null, (Object)val);
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, E[] values, Object val) {
        if (val == null) {
            return null;
        }
        if (type.isInstance(val)) {
            return (E)((Enum)val);
        }
        if (val instanceof String) {
            return Enum.valueOf(type, val.toString().trim().toUpperCase(Locale.ENGLISH));
        }
        if (values != null && values.length > 0 && val instanceof Number) {
            return values[((Number)val).intValue()];
        }
        return null;
    }
}

