/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;

public final class ReplicatedMapEntryViewHolderCodec {
    private static final int CREATION_TIME_FIELD_OFFSET = 0;
    private static final int HITS_FIELD_OFFSET = 8;
    private static final int LAST_ACCESS_TIME_FIELD_OFFSET = 16;
    private static final int LAST_UPDATE_TIME_FIELD_OFFSET = 24;
    private static final int TTL_MILLIS_FIELD_OFFSET = 32;
    private static final int INITIAL_FRAME_SIZE = 40;

    private ReplicatedMapEntryViewHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, ReplicatedMapEntryViewHolder replicatedMapEntryViewHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[40]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, replicatedMapEntryViewHolder.getCreationTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 8, replicatedMapEntryViewHolder.getHits());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, replicatedMapEntryViewHolder.getLastAccessTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, replicatedMapEntryViewHolder.getLastUpdateTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, replicatedMapEntryViewHolder.getTtlMillis());
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, replicatedMapEntryViewHolder.getKey());
        DataCodec.encode(clientMessage, replicatedMapEntryViewHolder.getValue());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ReplicatedMapEntryViewHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        long creationTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        long hits = FixedSizeTypesCodec.decodeLong(initialFrame.content, 8);
        long lastAccessTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        long lastUpdateTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        long ttlMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        Data key = DataCodec.decode(iterator);
        Data value = DataCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new ReplicatedMapEntryViewHolder(key, value, creationTime, hits, lastAccessTime, lastUpdateTime, ttlMillis);
    }
}

