/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMRequestKeyUpdate is the corresponding interface of NLMRequestKeyUpdate
type NLMRequestKeyUpdate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	NLM
	// GetSet1KeyRevision returns Set1KeyRevision (property field)
	GetSet1KeyRevision() byte
	// GetSet1ActivationTime returns Set1ActivationTime (property field)
	GetSet1ActivationTime() uint32
	// GetSet1ExpirationTime returns Set1ExpirationTime (property field)
	GetSet1ExpirationTime() uint32
	// GetSet2KeyRevision returns Set2KeyRevision (property field)
	GetSet2KeyRevision() byte
	// GetSet2ActivationTime returns Set2ActivationTime (property field)
	GetSet2ActivationTime() uint32
	// GetSet2ExpirationTime returns Set2ExpirationTime (property field)
	GetSet2ExpirationTime() uint32
	// GetDistributionKeyRevision returns DistributionKeyRevision (property field)
	GetDistributionKeyRevision() byte
	// IsNLMRequestKeyUpdate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMRequestKeyUpdate()
	// CreateBuilder creates a NLMRequestKeyUpdateBuilder
	CreateNLMRequestKeyUpdateBuilder() NLMRequestKeyUpdateBuilder
}

// _NLMRequestKeyUpdate is the data-structure of this message
type _NLMRequestKeyUpdate struct {
	NLMContract
	Set1KeyRevision         byte
	Set1ActivationTime      uint32
	Set1ExpirationTime      uint32
	Set2KeyRevision         byte
	Set2ActivationTime      uint32
	Set2ExpirationTime      uint32
	DistributionKeyRevision byte
}

var _ NLMRequestKeyUpdate = (*_NLMRequestKeyUpdate)(nil)
var _ NLMRequirements = (*_NLMRequestKeyUpdate)(nil)

// NewNLMRequestKeyUpdate factory function for _NLMRequestKeyUpdate
func NewNLMRequestKeyUpdate(set1KeyRevision byte, set1ActivationTime uint32, set1ExpirationTime uint32, set2KeyRevision byte, set2ActivationTime uint32, set2ExpirationTime uint32, distributionKeyRevision byte, apduLength uint16) *_NLMRequestKeyUpdate {
	_result := &_NLMRequestKeyUpdate{
		NLMContract:             NewNLM(apduLength),
		Set1KeyRevision:         set1KeyRevision,
		Set1ActivationTime:      set1ActivationTime,
		Set1ExpirationTime:      set1ExpirationTime,
		Set2KeyRevision:         set2KeyRevision,
		Set2ActivationTime:      set2ActivationTime,
		Set2ExpirationTime:      set2ExpirationTime,
		DistributionKeyRevision: distributionKeyRevision,
	}
	_result.NLMContract.(*_NLM)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMRequestKeyUpdateBuilder is a builder for NLMRequestKeyUpdate
type NLMRequestKeyUpdateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(set1KeyRevision byte, set1ActivationTime uint32, set1ExpirationTime uint32, set2KeyRevision byte, set2ActivationTime uint32, set2ExpirationTime uint32, distributionKeyRevision byte) NLMRequestKeyUpdateBuilder
	// WithSet1KeyRevision adds Set1KeyRevision (property field)
	WithSet1KeyRevision(byte) NLMRequestKeyUpdateBuilder
	// WithSet1ActivationTime adds Set1ActivationTime (property field)
	WithSet1ActivationTime(uint32) NLMRequestKeyUpdateBuilder
	// WithSet1ExpirationTime adds Set1ExpirationTime (property field)
	WithSet1ExpirationTime(uint32) NLMRequestKeyUpdateBuilder
	// WithSet2KeyRevision adds Set2KeyRevision (property field)
	WithSet2KeyRevision(byte) NLMRequestKeyUpdateBuilder
	// WithSet2ActivationTime adds Set2ActivationTime (property field)
	WithSet2ActivationTime(uint32) NLMRequestKeyUpdateBuilder
	// WithSet2ExpirationTime adds Set2ExpirationTime (property field)
	WithSet2ExpirationTime(uint32) NLMRequestKeyUpdateBuilder
	// WithDistributionKeyRevision adds DistributionKeyRevision (property field)
	WithDistributionKeyRevision(byte) NLMRequestKeyUpdateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() NLMBuilder
	// Build builds the NLMRequestKeyUpdate or returns an error if something is wrong
	Build() (NLMRequestKeyUpdate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMRequestKeyUpdate
}

// NewNLMRequestKeyUpdateBuilder() creates a NLMRequestKeyUpdateBuilder
func NewNLMRequestKeyUpdateBuilder() NLMRequestKeyUpdateBuilder {
	return &_NLMRequestKeyUpdateBuilder{_NLMRequestKeyUpdate: new(_NLMRequestKeyUpdate)}
}

type _NLMRequestKeyUpdateBuilder struct {
	*_NLMRequestKeyUpdate

	parentBuilder *_NLMBuilder

	collectedErr []error
}

var _ (NLMRequestKeyUpdateBuilder) = (*_NLMRequestKeyUpdateBuilder)(nil)

func (b *_NLMRequestKeyUpdateBuilder) setParent(contract NLMContract) {
	b.NLMContract = contract
	contract.(*_NLM)._SubType = b._NLMRequestKeyUpdate
}

func (b *_NLMRequestKeyUpdateBuilder) WithMandatoryFields(set1KeyRevision byte, set1ActivationTime uint32, set1ExpirationTime uint32, set2KeyRevision byte, set2ActivationTime uint32, set2ExpirationTime uint32, distributionKeyRevision byte) NLMRequestKeyUpdateBuilder {
	return b.WithSet1KeyRevision(set1KeyRevision).WithSet1ActivationTime(set1ActivationTime).WithSet1ExpirationTime(set1ExpirationTime).WithSet2KeyRevision(set2KeyRevision).WithSet2ActivationTime(set2ActivationTime).WithSet2ExpirationTime(set2ExpirationTime).WithDistributionKeyRevision(distributionKeyRevision)
}

func (b *_NLMRequestKeyUpdateBuilder) WithSet1KeyRevision(set1KeyRevision byte) NLMRequestKeyUpdateBuilder {
	b.Set1KeyRevision = set1KeyRevision
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) WithSet1ActivationTime(set1ActivationTime uint32) NLMRequestKeyUpdateBuilder {
	b.Set1ActivationTime = set1ActivationTime
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) WithSet1ExpirationTime(set1ExpirationTime uint32) NLMRequestKeyUpdateBuilder {
	b.Set1ExpirationTime = set1ExpirationTime
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) WithSet2KeyRevision(set2KeyRevision byte) NLMRequestKeyUpdateBuilder {
	b.Set2KeyRevision = set2KeyRevision
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) WithSet2ActivationTime(set2ActivationTime uint32) NLMRequestKeyUpdateBuilder {
	b.Set2ActivationTime = set2ActivationTime
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) WithSet2ExpirationTime(set2ExpirationTime uint32) NLMRequestKeyUpdateBuilder {
	b.Set2ExpirationTime = set2ExpirationTime
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) WithDistributionKeyRevision(distributionKeyRevision byte) NLMRequestKeyUpdateBuilder {
	b.DistributionKeyRevision = distributionKeyRevision
	return b
}

func (b *_NLMRequestKeyUpdateBuilder) Build() (NLMRequestKeyUpdate, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NLMRequestKeyUpdate.deepCopy(), nil
}

func (b *_NLMRequestKeyUpdateBuilder) MustBuild() NLMRequestKeyUpdate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMRequestKeyUpdateBuilder) Done() NLMBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewNLMBuilder().(*_NLMBuilder)
	}
	return b.parentBuilder
}

func (b *_NLMRequestKeyUpdateBuilder) buildForNLM() (NLM, error) {
	return b.Build()
}

func (b *_NLMRequestKeyUpdateBuilder) DeepCopy() any {
	_copy := b.CreateNLMRequestKeyUpdateBuilder().(*_NLMRequestKeyUpdateBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNLMRequestKeyUpdateBuilder creates a NLMRequestKeyUpdateBuilder
func (b *_NLMRequestKeyUpdate) CreateNLMRequestKeyUpdateBuilder() NLMRequestKeyUpdateBuilder {
	if b == nil {
		return NewNLMRequestKeyUpdateBuilder()
	}
	return &_NLMRequestKeyUpdateBuilder{_NLMRequestKeyUpdate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMRequestKeyUpdate) GetMessageType() uint8 {
	return 0x0D
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMRequestKeyUpdate) GetParent() NLMContract {
	return m.NLMContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMRequestKeyUpdate) GetSet1KeyRevision() byte {
	return m.Set1KeyRevision
}

func (m *_NLMRequestKeyUpdate) GetSet1ActivationTime() uint32 {
	return m.Set1ActivationTime
}

func (m *_NLMRequestKeyUpdate) GetSet1ExpirationTime() uint32 {
	return m.Set1ExpirationTime
}

func (m *_NLMRequestKeyUpdate) GetSet2KeyRevision() byte {
	return m.Set2KeyRevision
}

func (m *_NLMRequestKeyUpdate) GetSet2ActivationTime() uint32 {
	return m.Set2ActivationTime
}

func (m *_NLMRequestKeyUpdate) GetSet2ExpirationTime() uint32 {
	return m.Set2ExpirationTime
}

func (m *_NLMRequestKeyUpdate) GetDistributionKeyRevision() byte {
	return m.DistributionKeyRevision
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMRequestKeyUpdate(structType any) NLMRequestKeyUpdate {
	if casted, ok := structType.(NLMRequestKeyUpdate); ok {
		return casted
	}
	if casted, ok := structType.(*NLMRequestKeyUpdate); ok {
		return *casted
	}
	return nil
}

func (m *_NLMRequestKeyUpdate) GetTypeName() string {
	return "NLMRequestKeyUpdate"
}

func (m *_NLMRequestKeyUpdate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.NLMContract.(*_NLM).getLengthInBits(ctx))

	// Simple field (set1KeyRevision)
	lengthInBits += 8

	// Simple field (set1ActivationTime)
	lengthInBits += 32

	// Simple field (set1ExpirationTime)
	lengthInBits += 32

	// Simple field (set2KeyRevision)
	lengthInBits += 8

	// Simple field (set2ActivationTime)
	lengthInBits += 32

	// Simple field (set2ExpirationTime)
	lengthInBits += 32

	// Simple field (distributionKeyRevision)
	lengthInBits += 8

	return lengthInBits
}

func (m *_NLMRequestKeyUpdate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NLMRequestKeyUpdate) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_NLM, apduLength uint16) (__nLMRequestKeyUpdate NLMRequestKeyUpdate, err error) {
	m.NLMContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMRequestKeyUpdate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMRequestKeyUpdate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	set1KeyRevision, err := ReadSimpleField(ctx, "set1KeyRevision", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1KeyRevision' field"))
	}
	m.Set1KeyRevision = set1KeyRevision

	set1ActivationTime, err := ReadSimpleField(ctx, "set1ActivationTime", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1ActivationTime' field"))
	}
	m.Set1ActivationTime = set1ActivationTime

	set1ExpirationTime, err := ReadSimpleField(ctx, "set1ExpirationTime", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1ExpirationTime' field"))
	}
	m.Set1ExpirationTime = set1ExpirationTime

	set2KeyRevision, err := ReadSimpleField(ctx, "set2KeyRevision", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2KeyRevision' field"))
	}
	m.Set2KeyRevision = set2KeyRevision

	set2ActivationTime, err := ReadSimpleField(ctx, "set2ActivationTime", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2ActivationTime' field"))
	}
	m.Set2ActivationTime = set2ActivationTime

	set2ExpirationTime, err := ReadSimpleField(ctx, "set2ExpirationTime", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2ExpirationTime' field"))
	}
	m.Set2ExpirationTime = set2ExpirationTime

	distributionKeyRevision, err := ReadSimpleField(ctx, "distributionKeyRevision", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'distributionKeyRevision' field"))
	}
	m.DistributionKeyRevision = distributionKeyRevision

	if closeErr := readBuffer.CloseContext("NLMRequestKeyUpdate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMRequestKeyUpdate")
	}

	return m, nil
}

func (m *_NLMRequestKeyUpdate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMRequestKeyUpdate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMRequestKeyUpdate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMRequestKeyUpdate")
		}

		if err := WriteSimpleField[byte](ctx, "set1KeyRevision", m.GetSet1KeyRevision(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'set1KeyRevision' field")
		}

		if err := WriteSimpleField[uint32](ctx, "set1ActivationTime", m.GetSet1ActivationTime(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'set1ActivationTime' field")
		}

		if err := WriteSimpleField[uint32](ctx, "set1ExpirationTime", m.GetSet1ExpirationTime(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'set1ExpirationTime' field")
		}

		if err := WriteSimpleField[byte](ctx, "set2KeyRevision", m.GetSet2KeyRevision(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'set2KeyRevision' field")
		}

		if err := WriteSimpleField[uint32](ctx, "set2ActivationTime", m.GetSet2ActivationTime(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'set2ActivationTime' field")
		}

		if err := WriteSimpleField[uint32](ctx, "set2ExpirationTime", m.GetSet2ExpirationTime(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'set2ExpirationTime' field")
		}

		if err := WriteSimpleField[byte](ctx, "distributionKeyRevision", m.GetDistributionKeyRevision(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'distributionKeyRevision' field")
		}

		if popErr := writeBuffer.PopContext("NLMRequestKeyUpdate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMRequestKeyUpdate")
		}
		return nil
	}
	return m.NLMContract.(*_NLM).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMRequestKeyUpdate) IsNLMRequestKeyUpdate() {}

func (m *_NLMRequestKeyUpdate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMRequestKeyUpdate) deepCopy() *_NLMRequestKeyUpdate {
	if m == nil {
		return nil
	}
	_NLMRequestKeyUpdateCopy := &_NLMRequestKeyUpdate{
		m.NLMContract.(*_NLM).deepCopy(),
		m.Set1KeyRevision,
		m.Set1ActivationTime,
		m.Set1ExpirationTime,
		m.Set2KeyRevision,
		m.Set2ActivationTime,
		m.Set2ExpirationTime,
		m.DistributionKeyRevision,
	}
	_NLMRequestKeyUpdateCopy.NLMContract.(*_NLM)._SubType = m
	return _NLMRequestKeyUpdateCopy
}

func (m *_NLMRequestKeyUpdate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
