/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReadAtTimeDetails extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 655;
  }

  // Properties.
  protected final List<Long> reqTimes;
  protected final boolean useSimpleBounds;

  public ReadAtTimeDetails(List<Long> reqTimes, boolean useSimpleBounds) {
    super();
    this.reqTimes = reqTimes;
    this.useSimpleBounds = useSimpleBounds;
  }

  public List<Long> getReqTimes() {
    return reqTimes;
  }

  public boolean getUseSimpleBounds() {
    return useSimpleBounds;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReadAtTimeDetails");

    // Implicit Field (noOfReqTimes) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfReqTimes = (int) ((((getReqTimes()) == (null)) ? -(1) : COUNT(getReqTimes())));
    writeImplicitField("noOfReqTimes", noOfReqTimes, writeSignedInt(writeBuffer, 32));

    // Array Field (reqTimes)
    writeSimpleTypeArrayField("reqTimes", reqTimes, writeSignedLong(writeBuffer, 64));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (useSimpleBounds)
    writeSimpleField("useSimpleBounds", useSimpleBounds, writeBoolean(writeBuffer));

    writeBuffer.popContext("ReadAtTimeDetails");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReadAtTimeDetails _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (noOfReqTimes)
    lengthInBits += 32;

    // Array field
    if (reqTimes != null) {
      lengthInBits += 64 * reqTimes.size();
    }

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (useSimpleBounds)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ReadAtTimeDetails");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfReqTimes = readImplicitField("noOfReqTimes", readSignedInt(readBuffer, 32));

    List<Long> reqTimes =
        readCountArrayField("reqTimes", readSignedLong(readBuffer, 64), noOfReqTimes);

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean useSimpleBounds = readSimpleField("useSimpleBounds", readBoolean(readBuffer));

    readBuffer.closeContext("ReadAtTimeDetails");
    // Create the instance
    return new ReadAtTimeDetailsBuilderImpl(reqTimes, useSimpleBounds);
  }

  public static class ReadAtTimeDetailsBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final List<Long> reqTimes;
    private final boolean useSimpleBounds;

    public ReadAtTimeDetailsBuilderImpl(List<Long> reqTimes, boolean useSimpleBounds) {
      this.reqTimes = reqTimes;
      this.useSimpleBounds = useSimpleBounds;
    }

    public ReadAtTimeDetails build() {
      ReadAtTimeDetails readAtTimeDetails = new ReadAtTimeDetails(reqTimes, useSimpleBounds);
      return readAtTimeDetails;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReadAtTimeDetails)) {
      return false;
    }
    ReadAtTimeDetails that = (ReadAtTimeDetails) o;
    return (getReqTimes() == that.getReqTimes())
        && (getUseSimpleBounds() == that.getUseSimpleBounds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getReqTimes(), getUseSimpleBounds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
