/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.eclipse.jetty.websocket.core.AbstractExtension;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OutgoingEntry;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.BadPayloadException;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.exception.ProtocolException;
import org.eclipse.jetty.websocket.core.util.DemandChain;
import org.eclipse.jetty.websocket.core.util.WebSocketDemander;
import org.eclipse.jetty.websocket.core.util.WebSocketFlusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerMessageDeflateExtension
extends AbstractExtension
implements DemandChain {
    private static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    private static final ByteBuffer TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
    private static final Logger LOG = LoggerFactory.getLogger(PerMessageDeflateExtension.class);
    private static final int DEFAULT_BUF_SIZE = 8192;
    private final OutgoingFlusher outgoingFlusher = new OutgoingFlusher();
    private final IncomingDemander incomingFlusher = new IncomingDemander();
    private CompressionPool.Entry deflaterHolder;
    private CompressionPool.Entry inflaterHolder;
    private ExtensionConfig configRequested;
    private ExtensionConfig configNegotiated;
    private int deflateBufferSize = 8192;
    private int inflateBufferSize = 8192;
    private boolean incomingContextTakeover = true;
    private boolean outgoingContextTakeover = true;

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    @Override
    public void sendFrame(OutgoingEntry entry) {
        this.outgoingFlusher.sendFrame(entry);
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        this.incomingFlusher.onFrame(frame, callback);
    }

    @Override
    public void init(ExtensionConfig config, WebSocketComponents components) {
        this.configRequested = new ExtensionConfig(config);
        HashMap<String, String> paramsNegotiated = new HashMap<String, String>();
        block15: for (String key : config.getParameterKeys()) {
            switch (key = key.trim()) {
                case "client_max_window_bits": 
                case "server_max_window_bits": {
                    continue block15;
                }
                case "client_no_context_takeover": {
                    paramsNegotiated.put("client_no_context_takeover", null);
                    this.incomingContextTakeover = false;
                    continue block15;
                }
                case "server_no_context_takeover": {
                    paramsNegotiated.put("server_no_context_takeover", null);
                    this.outgoingContextTakeover = false;
                    continue block15;
                }
                case "@deflate_buffer_size": {
                    this.deflateBufferSize = config.getParameter(key, 8192);
                    continue block15;
                }
                case "@inflate_buffer_size": {
                    this.inflateBufferSize = config.getParameter(key, 8192);
                    continue block15;
                }
            }
            throw new IllegalArgumentException();
        }
        this.configNegotiated = new ExtensionConfig(config.getName(), paramsNegotiated);
        LOG.debug("config: outgoingContextTakover={}, incomingContextTakeover={} : {}", new Object[]{this.outgoingContextTakeover, this.incomingContextTakeover, this});
        super.init(this.configNegotiated, components);
    }

    @Override
    public void close() {
        this.incomingFlusher.closeFlusher();
        this.outgoingFlusher.closeFlusher();
        this.releaseInflater();
        this.releaseDeflater();
    }

    private static String toDetail(Inflater inflater) {
        return String.format("Inflater[finished=%b,read=%d,written=%d,remaining=%d,in=%d,out=%d]", inflater.finished(), inflater.getBytesRead(), inflater.getBytesWritten(), inflater.getRemaining(), inflater.getTotalIn(), inflater.getTotalOut());
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer buf) {
        if (buf == null || buf.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int limit = buf.limit();
        for (int i = TAIL_BYTES.length; i > 0; --i) {
            if (buf.get(limit - i) == TAIL_BYTES[TAIL_BYTES.length - i]) continue;
            return false;
        }
        return true;
    }

    public Deflater getDeflater() {
        if (this.deflaterHolder == null) {
            this.deflaterHolder = this.getDeflaterPool().acquire();
        }
        return (Deflater)this.deflaterHolder.get();
    }

    public Inflater getInflater() {
        if (this.inflaterHolder == null) {
            this.inflaterHolder = this.getInflaterPool().acquire();
        }
        return (Inflater)this.inflaterHolder.get();
    }

    public void releaseInflater() {
        if (this.inflaterHolder != null) {
            this.inflaterHolder.release();
            this.inflaterHolder = null;
        }
    }

    public void releaseDeflater() {
        if (this.deflaterHolder != null) {
            this.deflaterHolder.release();
            this.deflaterHolder = null;
        }
    }

    @Override
    public String toString() {
        return String.format("%s[requested=\"%s\", negotiated=\"%s\"]", TypeUtil.toShortName(this.getClass()), this.configRequested.getParameterizedName(), this.configNegotiated.getParameterizedName());
    }

    @Override
    protected void nextIncomingFrame(Frame frame, Callback callback) {
        if (frame.isFin() && !this.incomingContextTakeover) {
            LOG.debug("Incoming Context Reset");
            this.releaseInflater();
        }
        super.nextIncomingFrame(frame, callback);
    }

    @Override
    protected void nextOutgoingFrame(OutgoingEntry entry) {
        if (entry.getFrame().isFin() && !this.outgoingContextTakeover) {
            LOG.debug("Outgoing Context Reset");
            this.releaseDeflater();
        }
        super.nextOutgoingFrame(entry);
    }

    @Override
    public void setNextDemand(DemandChain nextDemand) {
        this.incomingFlusher.setNextDemand(nextDemand);
    }

    @Override
    public void demand() {
        this.incomingFlusher.demand();
    }

    private class OutgoingFlusher
    extends WebSocketFlusher {
        private OutgoingFlusher() {
        }

        @Override
        protected boolean onFrame(OutgoingEntry entry, boolean first) {
            boolean finished;
            if (first) {
                if (entry.getFrame().isControlFrame()) {
                    PerMessageDeflateExtension.this.nextOutgoingFrame(entry);
                    return true;
                }
                PerMessageDeflateExtension.this.getDeflater().setInput(entry.getFrame().getPayload().slice());
            }
            if (finished = this.deflate(entry, first)) {
                PerMessageDeflateExtension.this.getDeflater().setInput(BufferUtil.EMPTY_BUFFER);
            }
            return finished;
        }

        private boolean deflate(OutgoingEntry entry, boolean first) {
            boolean finished;
            Callback callback;
            ByteBuffer byteBuffer;
            block9: {
                int compressed;
                long maxFrameSize = PerMessageDeflateExtension.this.getConfiguration().getMaxFrameSize();
                int bufferSize = maxFrameSize <= 0L ? PerMessageDeflateExtension.this.deflateBufferSize : (int)Math.min(maxFrameSize, (long)PerMessageDeflateExtension.this.deflateBufferSize);
                RetainableByteBuffer.Mutable buffer = PerMessageDeflateExtension.this.getByteBufferPool().acquire(bufferSize, false);
                byteBuffer = buffer.getByteBuffer();
                callback = Callback.from((Callback)entry.getCallback(), () -> ((RetainableByteBuffer)buffer).release());
                finished = false;
                Deflater deflater = PerMessageDeflateExtension.this.getDeflater();
                do {
                    compressed = deflater.deflate(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), bufferSize - byteBuffer.position(), 2);
                    byteBuffer.limit(byteBuffer.limit() + compressed);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Compressed {} bytes {}", (Object)compressed, (Object)PerMessageDeflateExtension.toDetail(deflater));
                    }
                    if (byteBuffer.limit() != bufferSize) continue;
                    if (!PerMessageDeflateExtension.this.getConfiguration().isAutoFragment()) {
                        throw new MessageTooLargeException("Deflated payload exceeded the compress buffer size");
                    }
                    break block9;
                } while (compressed != 0);
                finished = true;
            }
            Frame frame = entry.getFrame();
            ByteBuffer payload = byteBuffer;
            if (payload.hasRemaining()) {
                if (finished && frame.isFin() && PerMessageDeflateExtension.endsWithTail(payload)) {
                    payload.limit(payload.limit() - TAIL_BYTES.length);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", (Object)BufferUtil.toDetailString((ByteBuffer)payload));
                    }
                }
            } else if (frame.isFin()) {
                payload = ByteBuffer.wrap(new byte[]{0});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: payload:{}", (Object)frame, (Object)payload.remaining());
            }
            Frame chunk = new Frame(first ? frame.getOpCode() : (byte)0);
            chunk.setRsv1(first && frame.getOpCode() != 0);
            chunk.setPayload(payload);
            chunk.setFin(frame.isFin() && finished);
            PerMessageDeflateExtension.this.nextOutgoingFrame(new OutgoingEntry.Builder(entry).frame(chunk).callback(callback).build());
            return finished;
        }
    }

    private class IncomingDemander
    extends WebSocketDemander {
        private boolean _tailBytes;
        private boolean _incomingCompressed;
        private AtomicReference<RetainableByteBuffer> _payloadRef;

        public IncomingDemander() {
            super(PerMessageDeflateExtension.this::nextIncomingFrame);
        }

        @Override
        protected boolean handle(Frame frame, Callback callback, boolean first) {
            if (first) {
                if (frame.isControlFrame()) {
                    this.emitFrame(frame, callback);
                    return true;
                }
                switch (frame.getOpCode()) {
                    case 1: 
                    case 2: {
                        this._incomingCompressed = frame.isRsv1();
                        break;
                    }
                    case 0: {
                        if (!frame.isRsv1()) break;
                        throw new ProtocolException("Invalid RSV1 set on permessage-deflate CONTINUATION frame");
                    }
                }
                if (!this._incomingCompressed) {
                    this.emitFrame(frame, callback);
                    return true;
                }
                this._tailBytes = false;
                PerMessageDeflateExtension.this.getInflater().setInput(frame.getPayload().slice());
            }
            try {
                return this.inflate(frame, callback, first);
            }
            catch (DataFormatException e) {
                throw new BadPayloadException(e);
            }
        }

        private boolean inflate(Frame frame, Callback callback, boolean first) throws DataFormatException {
            boolean complete;
            ByteBuffer byteBuffer;
            block5: {
                long maxFrameSize = PerMessageDeflateExtension.this.getConfiguration().getMaxFrameSize();
                int bufferSize = maxFrameSize <= 0L ? PerMessageDeflateExtension.this.inflateBufferSize : (int)Math.min(maxFrameSize, (long)PerMessageDeflateExtension.this.inflateBufferSize);
                RetainableByteBuffer.Mutable payload = PerMessageDeflateExtension.this.getByteBufferPool().acquire(bufferSize, false);
                this._payloadRef = new AtomicReference<RetainableByteBuffer.Mutable>(payload);
                byteBuffer = payload.getByteBuffer();
                Inflater inflater = PerMessageDeflateExtension.this.getInflater();
                complete = false;
                while (true) {
                    int decompressed = inflater.inflate(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), bufferSize - byteBuffer.position());
                    byteBuffer.limit(byteBuffer.limit() + decompressed);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Decompress: read {} {}", (Object)decompressed, (Object)PerMessageDeflateExtension.toDetail(inflater));
                    }
                    if (byteBuffer.limit() == bufferSize) {
                        if (!PerMessageDeflateExtension.this.getConfiguration().isAutoFragment()) {
                            throw new MessageTooLargeException("Inflated payload exceeded the decompress buffer size");
                        }
                        break block5;
                    }
                    if (decompressed != 0) continue;
                    if (this._tailBytes || !frame.isFin()) break;
                    inflater.setInput(TAIL_BYTES_BUF.slice());
                    this._tailBytes = true;
                }
                inflater.setInput(BufferUtil.EMPTY_BUFFER);
                complete = true;
            }
            Frame chunk = new Frame(first ? frame.getOpCode() : (byte)0);
            chunk.setRsv1(false);
            chunk.setPayload(byteBuffer);
            chunk.setFin(frame.isFin() && complete);
            boolean completeCallback = complete;
            AtomicReference<RetainableByteBuffer> payloadRef = this._payloadRef;
            Callback payloadCallback = Callback.from(() -> {
                this.releasePayload(payloadRef);
                if (completeCallback) {
                    callback.succeeded();
                }
            }, t -> {
                this.releasePayload(payloadRef);
                if (completeCallback) {
                    callback.failed(t);
                }
                this.failFlusher((Throwable)t);
            });
            this.emitFrame(chunk, payloadCallback);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decompress finished: {} {}", (Object)complete, (Object)chunk);
            }
            return complete;
        }

        @Override
        protected void onCompleteFailure(Throwable cause) {
            super.onCompleteFailure(cause);
            this.releasePayload(this._payloadRef);
        }

        private void releasePayload(AtomicReference<RetainableByteBuffer> reference) {
            if (reference == null) {
                return;
            }
            RetainableByteBuffer buffer = reference.getAndSet(null);
            if (buffer != null) {
                buffer.release();
            }
        }
    }
}

