/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.upgrade.StoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Upgrader.class);
    static final String VERSION_DB_NAME = "DB_VERSION";
    private final Environment _environment;
    private final ConfiguredObject<?> _parent;

    public Upgrader(Environment environment, ConfiguredObject<?> parent) {
        this._environment = environment;
        this._parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeIfNecessary() {
        boolean isEmpty = this._environment.getDatabaseNames().isEmpty();
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        try (Database versionDb = null;){
            versionDb = this._environment.openDatabase(null, VERSION_DB_NAME, dbConfig);
            if (versionDb.count() == 0L) {
                int sourceVersion = isEmpty ? 9 : this.identifyOldStoreVersion();
                DatabaseEntry key = new DatabaseEntry();
                IntegerBinding.intToEntry((int)sourceVersion, (DatabaseEntry)key);
                DatabaseEntry value = new DatabaseEntry();
                LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
                versionDb.put(null, key, value);
            }
            int version = this.getSourceVersion(versionDb);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Source message store version is " + version);
            }
            if (version > 9) {
                throw new StoreException("Database version " + version + " is higher than the most recent known version: 9");
            }
            this.performUpgradeFromVersion(version, versionDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSourceVersion(Database versionDb) {
        int version = -1;
        try (Cursor cursor = null;){
            cursor = versionDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            while (cursor.getNext(key, value, null) == OperationStatus.SUCCESS) {
                int ver = IntegerBinding.entryToInt((DatabaseEntry)key);
                if (ver <= version) continue;
                version = ver;
            }
        }
        return version;
    }

    void performUpgradeFromVersion(int sourceVersion, Database versionDb) throws StoreException {
        while (sourceVersion != 9) {
            this.upgrade(sourceVersion++, sourceVersion);
            DatabaseEntry key = new DatabaseEntry();
            IntegerBinding.intToEntry((int)sourceVersion, (DatabaseEntry)key);
            DatabaseEntry value = new DatabaseEntry();
            LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
            versionDb.put(null, key, value);
        }
    }

    void upgrade(int fromVersion, int toVersion) throws StoreException {
        try {
            Class<?> upgradeClass = Class.forName("org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeFrom" + fromVersion + "To" + toVersion);
            Constructor<?> ctr = upgradeClass.getConstructor(new Class[0]);
            StoreUpgrade upgrade = (StoreUpgrade)ctr.newInstance(new Object[0]);
            upgrade.performUpgrade(this._environment, UpgradeInteractionHandler.DEFAULT_HANDLER, this._parent);
        }
        catch (ClassNotFoundException e) {
            throw new StoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new StoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new StoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new StoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StoreException("Unable to upgrade BDB data store from version " + fromVersion + " to version" + toVersion, (Throwable)e);
        }
    }

    private int identifyOldStoreVersion() throws DatabaseException {
        int version = 9;
        for (String databaseName : this._environment.getDatabaseNames()) {
            if (!databaseName.contains("_v")) continue;
            int versionIndex = databaseName.indexOf("_v");
            if (versionIndex == -1) {
                versionIndex = 1;
            }
            version = Integer.parseInt(databaseName.substring(versionIndex + 2));
            break;
        }
        return version;
    }
}

