/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;

public class ConsumerManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long CHANNEL_EXPIRED_TIMEOUT = 120000L;
    private final ConcurrentMap<String, ConsumerGroupInfo> consumerTable = new ConcurrentHashMap<String, ConsumerGroupInfo>(1024);
    private final ConsumerIdsChangeListener consumerIdsChangeListener;

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener) {
        this.consumerIdsChangeListener = consumerIdsChangeListener;
    }

    public ClientChannelInfo findChannel(String group, String clientId) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(clientId);
        }
        return null;
    }

    public SubscriptionData findSubscriptionData(String group, String topic) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findSubscriptionData(topic);
        }
        return null;
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group) {
        return (ConsumerGroupInfo)this.consumerTable.get(group);
    }

    public int findSubscriptionDataCount(String group) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.getSubscriptionTable().size();
        }
        return 0;
    }

    public void doChannelCloseEvent(String remoteAddr, Channel channel) {
        for (Map.Entry next : this.consumerTable.entrySet()) {
            ConsumerGroupInfo remove;
            ConsumerGroupInfo info = (ConsumerGroupInfo)next.getValue();
            boolean removed = info.doChannelCloseEvent(remoteAddr, channel);
            if (!removed) continue;
            if (info.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(next.getKey())) != null) {
                log.info("unregister consumer ok, no any connection, and remove consumer group, {}", next.getKey());
                this.consumerIdsChangeListener.handle(ConsumerGroupEvent.UNREGISTER, (String)next.getKey(), new Object[0]);
            }
            this.consumerIdsChangeListener.handle(ConsumerGroupEvent.CHANGE, (String)next.getKey(), info.getAllChannel());
        }
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            consumerGroupInfo = prev != null ? prev : tmp;
        }
        boolean r1 = consumerGroupInfo.updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere);
        boolean r2 = consumerGroupInfo.updateSubscription(subList);
        if ((r1 || r2) && isNotifyConsumerIdsChangedEnable) {
            this.consumerIdsChangeListener.handle(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
        }
        this.consumerIdsChangeListener.handle(ConsumerGroupEvent.REGISTER, group, subList);
        return r1 || r2;
    }

    public void unregisterConsumer(String group, ClientChannelInfo clientChannelInfo, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)this.consumerTable.get(group);
        if (null != consumerGroupInfo) {
            ConsumerGroupInfo remove;
            consumerGroupInfo.unregisterChannel(clientChannelInfo);
            if (consumerGroupInfo.getChannelInfoTable().isEmpty() && (remove = (ConsumerGroupInfo)this.consumerTable.remove(group)) != null) {
                log.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)group);
                this.consumerIdsChangeListener.handle(ConsumerGroupEvent.UNREGISTER, group, new Object[0]);
            }
            if (isNotifyConsumerIdsChangedEnable) {
                this.consumerIdsChangeListener.handle(ConsumerGroupEvent.CHANGE, group, consumerGroupInfo.getAllChannel());
            }
        }
    }

    public void scanNotActiveChannel() {
        Iterator it = this.consumerTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String group = (String)next.getKey();
            ConsumerGroupInfo consumerGroupInfo = (ConsumerGroupInfo)next.getValue();
            ConcurrentMap<Channel, ClientChannelInfo> channelInfoTable = consumerGroupInfo.getChannelInfoTable();
            Iterator itChannel = channelInfoTable.entrySet().iterator();
            while (itChannel.hasNext()) {
                Map.Entry nextChannel = itChannel.next();
                ClientChannelInfo clientChannelInfo = (ClientChannelInfo)nextChannel.getValue();
                long diff = System.currentTimeMillis() - clientChannelInfo.getLastUpdateTimestamp();
                if (diff <= 120000L) continue;
                log.warn("SCAN: remove expired channel from ConsumerManager consumerTable. channel={}, consumerGroup={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)clientChannelInfo.getChannel()), (Object)group);
                RemotingUtil.closeChannel((Channel)clientChannelInfo.getChannel());
                itChannel.remove();
            }
            if (!channelInfoTable.isEmpty()) continue;
            log.warn("SCAN: remove expired channel from ConsumerManager consumerTable, all clear, consumerGroup={}", (Object)group);
            it.remove();
        }
    }

    public HashSet<String> queryTopicConsumeByWho(String topic) {
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            ConcurrentMap<String, SubscriptionData> subscriptionTable = ((ConsumerGroupInfo)entry.getValue()).getSubscriptionTable();
            if (!subscriptionTable.containsKey(topic)) continue;
            groups.add((String)entry.getKey());
        }
        return groups;
    }
}

