/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.stats;

import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.statistics.StatisticsItem;
import org.apache.rocketmq.common.statistics.StatisticsItemFormatter;
import org.apache.rocketmq.common.statistics.StatisticsItemPrinter;
import org.apache.rocketmq.common.statistics.StatisticsItemScheduledIncrementPrinter;
import org.apache.rocketmq.common.statistics.StatisticsItemScheduledPrinter;
import org.apache.rocketmq.common.statistics.StatisticsItemStateGetter;
import org.apache.rocketmq.common.statistics.StatisticsKindMeta;
import org.apache.rocketmq.common.statistics.StatisticsManager;
import org.apache.rocketmq.common.stats.MomentStatsItemSet;
import org.apache.rocketmq.common.stats.StatsItem;
import org.apache.rocketmq.common.stats.StatsItemSet;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class BrokerStatsManager {
    @Deprecated
    public static final String QUEUE_PUT_NUMS = "QUEUE_PUT_NUMS";
    @Deprecated
    public static final String QUEUE_PUT_SIZE = "QUEUE_PUT_SIZE";
    @Deprecated
    public static final String QUEUE_GET_NUMS = "QUEUE_GET_NUMS";
    @Deprecated
    public static final String QUEUE_GET_SIZE = "QUEUE_GET_SIZE";
    @Deprecated
    public static final String TOPIC_PUT_NUMS = "TOPIC_PUT_NUMS";
    @Deprecated
    public static final String TOPIC_PUT_SIZE = "TOPIC_PUT_SIZE";
    @Deprecated
    public static final String GROUP_GET_NUMS = "GROUP_GET_NUMS";
    @Deprecated
    public static final String GROUP_GET_SIZE = "GROUP_GET_SIZE";
    @Deprecated
    public static final String SNDBCK_PUT_NUMS = "SNDBCK_PUT_NUMS";
    @Deprecated
    public static final String BROKER_PUT_NUMS = "BROKER_PUT_NUMS";
    @Deprecated
    public static final String BROKER_GET_NUMS = "BROKER_GET_NUMS";
    @Deprecated
    public static final String GROUP_GET_FROM_DISK_NUMS = "GROUP_GET_FROM_DISK_NUMS";
    @Deprecated
    public static final String GROUP_GET_FROM_DISK_SIZE = "GROUP_GET_FROM_DISK_SIZE";
    @Deprecated
    public static final String BROKER_GET_FROM_DISK_NUMS = "BROKER_GET_FROM_DISK_NUMS";
    @Deprecated
    public static final String BROKER_GET_FROM_DISK_SIZE = "BROKER_GET_FROM_DISK_SIZE";
    @Deprecated
    public static final String COMMERCIAL_SEND_TIMES = "COMMERCIAL_SEND_TIMES";
    @Deprecated
    public static final String COMMERCIAL_SNDBCK_TIMES = "COMMERCIAL_SNDBCK_TIMES";
    @Deprecated
    public static final String COMMERCIAL_RCV_TIMES = "COMMERCIAL_RCV_TIMES";
    @Deprecated
    public static final String COMMERCIAL_RCV_EPOLLS = "COMMERCIAL_RCV_EPOLLS";
    @Deprecated
    public static final String COMMERCIAL_SEND_SIZE = "COMMERCIAL_SEND_SIZE";
    @Deprecated
    public static final String COMMERCIAL_RCV_SIZE = "COMMERCIAL_RCV_SIZE";
    @Deprecated
    public static final String COMMERCIAL_PERM_FAILURES = "COMMERCIAL_PERM_FAILURES";
    public static final String TOPIC_PUT_LATENCY = "TOPIC_PUT_LATENCY";
    public static final String GROUP_ACK_NUMS = "GROUP_ACK_NUMS";
    public static final String GROUP_CK_NUMS = "GROUP_CK_NUMS";
    public static final String DLQ_PUT_NUMS = "DLQ_PUT_NUMS";
    public static final String BROKER_ACK_NUMS = "BROKER_ACK_NUMS";
    public static final String BROKER_CK_NUMS = "BROKER_CK_NUMS";
    public static final String BROKER_GET_NUMS_WITHOUT_SYSTEM_TOPIC = "BROKER_GET_NUMS_WITHOUT_SYSTEM_TOPIC";
    public static final String BROKER_PUT_NUMS_WITHOUT_SYSTEM_TOPIC = "BROKER_PUT_NUMS_WITHOUT_SYSTEM_TOPIC";
    public static final String SNDBCK2DLQ_TIMES = "SNDBCK2DLQ_TIMES";
    public static final String COMMERCIAL_OWNER = "Owner";
    public static final String ACCOUNT_OWNER_PARENT = "OWNER_PARENT";
    public static final String ACCOUNT_OWNER_SELF = "OWNER_SELF";
    public static final long ACCOUNT_STAT_INVERTAL = 60000L;
    public static final String ACCOUNT_AUTH_TYPE = "AUTH_TYPE";
    public static final String ACCOUNT_SEND = "SEND";
    public static final String ACCOUNT_RCV = "RCV";
    public static final String ACCOUNT_SEND_BACK = "SEND_BACK";
    public static final String ACCOUNT_SEND_BACK_TO_DLQ = "SEND_BACK_TO_DLQ";
    public static final String ACCOUNT_AUTH_FAILED = "AUTH_FAILED";
    public static final String ACCOUNT_SEND_REJ = "SEND_REJ";
    public static final String ACCOUNT_REV_REJ = "RCV_REJ";
    public static final String MSG_NUM = "MSG_NUM";
    public static final String MSG_SIZE = "MSG_SIZE";
    public static final String SUCCESS_MSG_NUM = "SUCCESS_MSG_NUM";
    public static final String FAILURE_MSG_NUM = "FAILURE_MSG_NUM";
    public static final String COMMERCIAL_MSG_NUM = "COMMERCIAL_MSG_NUM";
    public static final String SUCCESS_REQ_NUM = "SUCCESS_REQ_NUM";
    public static final String FAILURE_REQ_NUM = "FAILURE_REQ_NUM";
    public static final String SUCCESS_MSG_SIZE = "SUCCESS_MSG_SIZE";
    public static final String FAILURE_MSG_SIZE = "FAILURE_MSG_SIZE";
    public static final String RT = "RT";
    public static final String INNER_RT = "INNER_RT";
    @Deprecated
    public static final String GROUP_GET_FALL_SIZE = "GROUP_GET_FALL_SIZE";
    @Deprecated
    public static final String GROUP_GET_FALL_TIME = "GROUP_GET_FALL_TIME";
    @Deprecated
    public static final String GROUP_GET_LATENCY = "GROUP_GET_LATENCY";
    public static final String CONSUMER_REGISTER_TIME = "CONSUMER_REGISTER_TIME";
    public static final String PRODUCER_REGISTER_TIME = "PRODUCER_REGISTER_TIME";
    public static final String CHANNEL_ACTIVITY = "CHANNEL_ACTIVITY";
    public static final String CHANNEL_ACTIVITY_CONNECT = "CONNECT";
    public static final String CHANNEL_ACTIVITY_IDLE = "IDLE";
    public static final String CHANNEL_ACTIVITY_EXCEPTION = "EXCEPTION";
    public static final String CHANNEL_ACTIVITY_CLOSE = "CLOSE";
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStats");
    private static final Logger COMMERCIAL_LOG = LoggerFactory.getLogger((String)"RocketmqCommercial");
    private static final Logger ACCOUNT_LOG = LoggerFactory.getLogger((String)"RocketmqAccount");
    private static final Logger DLQ_STAT_LOG = LoggerFactory.getLogger((String)"RocketmqDLQStats");
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledExecutorService commercialExecutor;
    private ScheduledExecutorService accountExecutor;
    private final HashMap<String, StatsItemSet> statsTable = new HashMap();
    private final String clusterName;
    private final boolean enableQueueStat;
    private MomentStatsItemSet momentStatsItemSetFallSize;
    private MomentStatsItemSet momentStatsItemSetFallTime;
    private final StatisticsManager accountStatManager = new StatisticsManager();
    private StateGetter produerStateGetter;
    private StateGetter consumerStateGetter;
    private BrokerConfig brokerConfig;

    public BrokerStatsManager(BrokerConfig brokerConfig) {
        this.brokerConfig = brokerConfig;
        this.enableQueueStat = brokerConfig.isEnableDetailStat();
        this.initScheduleService();
        this.clusterName = brokerConfig.getBrokerClusterName();
        this.init();
    }

    public BrokerStatsManager(String clusterName, boolean enableQueueStat) {
        this.clusterName = clusterName;
        this.enableQueueStat = enableQueueStat;
        this.initScheduleService();
        this.init();
    }

    public void init() {
        this.momentStatsItemSetFallSize = new MomentStatsItemSet(GROUP_GET_FALL_SIZE, this.scheduledExecutorService, log);
        this.momentStatsItemSetFallTime = new MomentStatsItemSet(GROUP_GET_FALL_TIME, this.scheduledExecutorService, log);
        if (this.enableQueueStat) {
            this.statsTable.put(QUEUE_PUT_NUMS, new StatsItemSet(QUEUE_PUT_NUMS, this.scheduledExecutorService, log));
            this.statsTable.put(QUEUE_PUT_SIZE, new StatsItemSet(QUEUE_PUT_SIZE, this.scheduledExecutorService, log));
            this.statsTable.put(QUEUE_GET_NUMS, new StatsItemSet(QUEUE_GET_NUMS, this.scheduledExecutorService, log));
            this.statsTable.put(QUEUE_GET_SIZE, new StatsItemSet(QUEUE_GET_SIZE, this.scheduledExecutorService, log));
        }
        this.statsTable.put(TOPIC_PUT_NUMS, new StatsItemSet(TOPIC_PUT_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(TOPIC_PUT_SIZE, new StatsItemSet(TOPIC_PUT_SIZE, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_GET_NUMS, new StatsItemSet(GROUP_GET_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_GET_SIZE, new StatsItemSet(GROUP_GET_SIZE, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_ACK_NUMS, new StatsItemSet(GROUP_ACK_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_CK_NUMS, new StatsItemSet(GROUP_CK_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_GET_LATENCY, new StatsItemSet(GROUP_GET_LATENCY, this.scheduledExecutorService, log));
        this.statsTable.put(TOPIC_PUT_LATENCY, new StatsItemSet(TOPIC_PUT_LATENCY, this.scheduledExecutorService, log));
        this.statsTable.put(SNDBCK_PUT_NUMS, new StatsItemSet(SNDBCK_PUT_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(DLQ_PUT_NUMS, new StatsItemSet(DLQ_PUT_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_PUT_NUMS, new StatsItemSet(BROKER_PUT_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_GET_NUMS, new StatsItemSet(BROKER_GET_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_ACK_NUMS, new StatsItemSet(BROKER_ACK_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_CK_NUMS, new StatsItemSet(BROKER_CK_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_GET_NUMS_WITHOUT_SYSTEM_TOPIC, new StatsItemSet(BROKER_GET_NUMS_WITHOUT_SYSTEM_TOPIC, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_PUT_NUMS_WITHOUT_SYSTEM_TOPIC, new StatsItemSet(BROKER_PUT_NUMS_WITHOUT_SYSTEM_TOPIC, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_GET_FROM_DISK_NUMS, new StatsItemSet(GROUP_GET_FROM_DISK_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(GROUP_GET_FROM_DISK_SIZE, new StatsItemSet(GROUP_GET_FROM_DISK_SIZE, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_GET_FROM_DISK_NUMS, new StatsItemSet(BROKER_GET_FROM_DISK_NUMS, this.scheduledExecutorService, log));
        this.statsTable.put(BROKER_GET_FROM_DISK_SIZE, new StatsItemSet(BROKER_GET_FROM_DISK_SIZE, this.scheduledExecutorService, log));
        this.statsTable.put(SNDBCK2DLQ_TIMES, new StatsItemSet(SNDBCK2DLQ_TIMES, this.scheduledExecutorService, DLQ_STAT_LOG));
        this.statsTable.put(COMMERCIAL_SEND_TIMES, new StatsItemSet(COMMERCIAL_SEND_TIMES, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(COMMERCIAL_RCV_TIMES, new StatsItemSet(COMMERCIAL_RCV_TIMES, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(COMMERCIAL_SEND_SIZE, new StatsItemSet(COMMERCIAL_SEND_SIZE, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(COMMERCIAL_RCV_SIZE, new StatsItemSet(COMMERCIAL_RCV_SIZE, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(COMMERCIAL_RCV_EPOLLS, new StatsItemSet(COMMERCIAL_RCV_EPOLLS, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(COMMERCIAL_SNDBCK_TIMES, new StatsItemSet(COMMERCIAL_SNDBCK_TIMES, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(COMMERCIAL_PERM_FAILURES, new StatsItemSet(COMMERCIAL_PERM_FAILURES, this.commercialExecutor, COMMERCIAL_LOG));
        this.statsTable.put(CONSUMER_REGISTER_TIME, new StatsItemSet(CONSUMER_REGISTER_TIME, this.scheduledExecutorService, log));
        this.statsTable.put(PRODUCER_REGISTER_TIME, new StatsItemSet(PRODUCER_REGISTER_TIME, this.scheduledExecutorService, log));
        this.statsTable.put(CHANNEL_ACTIVITY, new StatsItemSet(CHANNEL_ACTIVITY, this.scheduledExecutorService, log));
        StatisticsItemFormatter formatter = new StatisticsItemFormatter();
        this.accountStatManager.setBriefMeta(new Pair[]{Pair.of((Object)RT, (Object)new long[][]{{50L, 50L}, {100L, 10L}, {1000L, 10L}}), Pair.of((Object)INNER_RT, (Object)new long[][]{{10L, 10L}, {100L, 10L}, {1000L, 10L}})});
        String[] itemNames = new String[]{MSG_NUM, SUCCESS_MSG_NUM, FAILURE_MSG_NUM, COMMERCIAL_MSG_NUM, SUCCESS_REQ_NUM, FAILURE_REQ_NUM, MSG_SIZE, SUCCESS_MSG_SIZE, FAILURE_MSG_SIZE, RT, INNER_RT};
        this.accountStatManager.addStatisticsKindMeta(this.createStatisticsKindMeta(ACCOUNT_SEND, itemNames, this.accountExecutor, formatter, ACCOUNT_LOG, 60000L));
        this.accountStatManager.addStatisticsKindMeta(this.createStatisticsKindMeta(ACCOUNT_RCV, itemNames, this.accountExecutor, formatter, ACCOUNT_LOG, 60000L));
        this.accountStatManager.addStatisticsKindMeta(this.createStatisticsKindMeta(ACCOUNT_SEND_BACK, itemNames, this.accountExecutor, formatter, ACCOUNT_LOG, 60000L));
        this.accountStatManager.addStatisticsKindMeta(this.createStatisticsKindMeta(ACCOUNT_SEND_BACK_TO_DLQ, itemNames, this.accountExecutor, formatter, ACCOUNT_LOG, 60000L));
        this.accountStatManager.addStatisticsKindMeta(this.createStatisticsKindMeta(ACCOUNT_SEND_REJ, itemNames, this.accountExecutor, formatter, ACCOUNT_LOG, 60000L));
        this.accountStatManager.addStatisticsKindMeta(this.createStatisticsKindMeta(ACCOUNT_REV_REJ, itemNames, this.accountExecutor, formatter, ACCOUNT_LOG, 60000L));
        this.accountStatManager.setStatisticsItemStateGetter(new StatisticsItemStateGetter(){

            public boolean online(StatisticsItem item) {
                String[] strArr = null;
                try {
                    strArr = BrokerStatsManager.this.splitAccountStatKey(item.getStatObject());
                }
                catch (Exception e) {
                    log.warn("parse account stat key failed, key: {}", (Object)item.getStatObject());
                    return false;
                }
                if (strArr == null || strArr.length < 4) {
                    return false;
                }
                String instanceId = strArr[1];
                String topic = strArr[2];
                String group = strArr[3];
                String kind = item.getStatKind();
                if (BrokerStatsManager.ACCOUNT_SEND.equals(kind) || BrokerStatsManager.ACCOUNT_SEND_REJ.equals(kind)) {
                    return BrokerStatsManager.this.produerStateGetter.online(instanceId, group, topic);
                }
                if (BrokerStatsManager.ACCOUNT_RCV.equals(kind) || BrokerStatsManager.ACCOUNT_SEND_BACK.equals(kind) || BrokerStatsManager.ACCOUNT_SEND_BACK_TO_DLQ.equals(kind) || BrokerStatsManager.ACCOUNT_REV_REJ.equals(kind)) {
                    return BrokerStatsManager.this.consumerStateGetter.online(instanceId, group, topic);
                }
                return false;
            }
        });
    }

    private void initScheduleService() {
        this.scheduledExecutorService = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("BrokerStatsThread", true, (BrokerIdentity)this.brokerConfig));
        this.commercialExecutor = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("CommercialStatsThread", true, (BrokerIdentity)this.brokerConfig));
        this.accountExecutor = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("AccountStatsThread", true, (BrokerIdentity)this.brokerConfig));
    }

    public MomentStatsItemSet getMomentStatsItemSetFallSize() {
        return this.momentStatsItemSetFallSize;
    }

    public MomentStatsItemSet getMomentStatsItemSetFallTime() {
        return this.momentStatsItemSetFallTime;
    }

    public StateGetter getProduerStateGetter() {
        return this.produerStateGetter;
    }

    public void setProduerStateGetter(StateGetter produerStateGetter) {
        this.produerStateGetter = produerStateGetter;
    }

    public StateGetter getConsumerStateGetter() {
        return this.consumerStateGetter;
    }

    public void setConsumerStateGetter(StateGetter consumerStateGetter) {
        this.consumerStateGetter = consumerStateGetter;
    }

    public void start() {
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        this.commercialExecutor.shutdown();
    }

    public StatsItem getStatsItem(String statsName, String statsKey) {
        try {
            return this.statsTable.get(statsName).getStatsItem(statsKey);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onTopicDeleted(String topic) {
        this.statsTable.get(TOPIC_PUT_NUMS).delValue(topic);
        this.statsTable.get(TOPIC_PUT_SIZE).delValue(topic);
        if (this.enableQueueStat) {
            this.statsTable.get(QUEUE_PUT_NUMS).delValueByPrefixKey(topic, "@");
            this.statsTable.get(QUEUE_PUT_SIZE).delValueByPrefixKey(topic, "@");
        }
        this.statsTable.get(GROUP_GET_NUMS).delValueByPrefixKey(topic, "@");
        this.statsTable.get(GROUP_GET_SIZE).delValueByPrefixKey(topic, "@");
        this.statsTable.get(QUEUE_GET_NUMS).delValueByPrefixKey(topic, "@");
        this.statsTable.get(QUEUE_GET_SIZE).delValueByPrefixKey(topic, "@");
        this.statsTable.get(SNDBCK_PUT_NUMS).delValueByPrefixKey(topic, "@");
        this.statsTable.get(GROUP_GET_LATENCY).delValueByInfixKey(topic, "@");
        this.momentStatsItemSetFallSize.delValueByInfixKey(topic, "@");
        this.momentStatsItemSetFallTime.delValueByInfixKey(topic, "@");
    }

    public void onGroupDeleted(String group) {
        this.statsTable.get(GROUP_GET_NUMS).delValueBySuffixKey(group, "@");
        this.statsTable.get(GROUP_GET_SIZE).delValueBySuffixKey(group, "@");
        if (this.enableQueueStat) {
            this.statsTable.get(QUEUE_GET_NUMS).delValueBySuffixKey(group, "@");
            this.statsTable.get(QUEUE_GET_SIZE).delValueBySuffixKey(group, "@");
        }
        this.statsTable.get(SNDBCK_PUT_NUMS).delValueBySuffixKey(group, "@");
        this.statsTable.get(GROUP_GET_LATENCY).delValueBySuffixKey(group, "@");
        this.momentStatsItemSetFallSize.delValueBySuffixKey(group, "@");
        this.momentStatsItemSetFallTime.delValueBySuffixKey(group, "@");
    }

    public void incQueuePutNums(String topic, Integer queueId) {
        if (this.enableQueueStat) {
            this.statsTable.get(QUEUE_PUT_NUMS).addValue(this.buildStatsKey(topic, queueId), 1, 1);
        }
    }

    public void incQueuePutNums(String topic, Integer queueId, int num, int times) {
        if (this.enableQueueStat) {
            this.statsTable.get(QUEUE_PUT_NUMS).addValue(this.buildStatsKey(topic, queueId), num, times);
        }
    }

    public void incQueuePutSize(String topic, Integer queueId, int size) {
        if (this.enableQueueStat) {
            this.statsTable.get(QUEUE_PUT_SIZE).addValue(this.buildStatsKey(topic, queueId), size, 1);
        }
    }

    public void incQueueGetNums(String group, String topic, Integer queueId, int incValue) {
        if (this.enableQueueStat) {
            String statsKey = this.buildStatsKey(topic, queueId, group);
            this.statsTable.get(QUEUE_GET_NUMS).addValue(statsKey, incValue, 1);
        }
    }

    public void incQueueGetSize(String group, String topic, Integer queueId, int incValue) {
        if (this.enableQueueStat) {
            String statsKey = this.buildStatsKey(topic, queueId, group);
            this.statsTable.get(QUEUE_GET_SIZE).addValue(statsKey, incValue, 1);
        }
    }

    public void incConsumerRegisterTime(int incValue) {
        this.statsTable.get(CONSUMER_REGISTER_TIME).addValue(this.clusterName, incValue, 1);
    }

    public void incProducerRegisterTime(int incValue) {
        this.statsTable.get(PRODUCER_REGISTER_TIME).addValue(this.clusterName, incValue, 1);
    }

    public void incChannelConnectNum() {
        this.statsTable.get(CHANNEL_ACTIVITY).addValue(CHANNEL_ACTIVITY_CONNECT, 1, 1);
    }

    public void incChannelCloseNum() {
        this.statsTable.get(CHANNEL_ACTIVITY).addValue(CHANNEL_ACTIVITY_CLOSE, 1, 1);
    }

    public void incChannelExceptionNum() {
        this.statsTable.get(CHANNEL_ACTIVITY).addValue(CHANNEL_ACTIVITY_EXCEPTION, 1, 1);
    }

    public void incChannelIdleNum() {
        this.statsTable.get(CHANNEL_ACTIVITY).addValue(CHANNEL_ACTIVITY_IDLE, 1, 1);
    }

    public void incTopicPutNums(String topic) {
        this.statsTable.get(TOPIC_PUT_NUMS).addValue(topic, 1, 1);
    }

    public void incTopicPutNums(String topic, int num, int times) {
        this.statsTable.get(TOPIC_PUT_NUMS).addValue(topic, num, times);
    }

    public void incTopicPutSize(String topic, int size) {
        this.statsTable.get(TOPIC_PUT_SIZE).addValue(topic, size, 1);
    }

    public void incGroupGetNums(String group, String topic, int incValue) {
        String statsKey = this.buildStatsKey(topic, group);
        this.statsTable.get(GROUP_GET_NUMS).addValue(statsKey, incValue, 1);
    }

    public void incGroupCkNums(String group, String topic, int incValue) {
        String statsKey = this.buildStatsKey(topic, group);
        this.statsTable.get(GROUP_CK_NUMS).addValue(statsKey, incValue, 1);
    }

    public void incGroupAckNums(String group, String topic, int incValue) {
        String statsKey = this.buildStatsKey(topic, group);
        this.statsTable.get(GROUP_ACK_NUMS).addValue(statsKey, incValue, 1);
    }

    public String buildStatsKey(String topic, String group) {
        StringBuilder strBuilder = topic != null && group != null ? new StringBuilder(topic.length() + group.length() + 1) : new StringBuilder();
        strBuilder.append(topic).append("@").append(group);
        return strBuilder.toString();
    }

    public String buildStatsKey(String topic, int queueId) {
        StringBuilder strBuilder = topic != null ? new StringBuilder(topic.length() + 5) : new StringBuilder();
        strBuilder.append(topic).append("@").append(queueId);
        return strBuilder.toString();
    }

    public String buildStatsKey(String topic, int queueId, String group) {
        StringBuilder strBuilder = topic != null && group != null ? new StringBuilder(topic.length() + group.length() + 6) : new StringBuilder();
        strBuilder.append(topic).append("@").append(queueId).append("@").append(group);
        return strBuilder.toString();
    }

    public String buildStatsKey(int queueId, String topic, String group) {
        StringBuilder strBuilder = topic != null && group != null ? new StringBuilder(topic.length() + group.length() + 6) : new StringBuilder();
        strBuilder.append(queueId).append("@").append(topic).append("@").append(group);
        return strBuilder.toString();
    }

    public void incGroupGetSize(String group, String topic, int incValue) {
        String statsKey = this.buildStatsKey(topic, group);
        this.statsTable.get(GROUP_GET_SIZE).addValue(statsKey, incValue, 1);
    }

    public void incGroupGetLatency(String group, String topic, int queueId, int incValue) {
        String statsKey = this.enableQueueStat ? this.buildStatsKey(queueId, topic, group) : this.buildStatsKey(topic, group);
        this.statsTable.get(GROUP_GET_LATENCY).addRTValue(statsKey, incValue, 1);
    }

    public void incTopicPutLatency(String topic, int queueId, int incValue) {
        StringBuilder statsKey = topic != null ? new StringBuilder(topic.length() + 6) : new StringBuilder(6);
        statsKey.append(queueId).append("@").append(topic);
        this.statsTable.get(TOPIC_PUT_LATENCY).addValue(statsKey.toString(), incValue, 1);
    }

    public void incBrokerPutNums() {
        this.statsTable.get(BROKER_PUT_NUMS).getAndCreateStatsItem(this.clusterName).getValue().add(1L);
    }

    public void incBrokerPutNums(String topic, int incValue) {
        this.statsTable.get(BROKER_PUT_NUMS).getAndCreateStatsItem(this.clusterName).getValue().add(incValue);
        this.incBrokerPutNumsWithoutSystemTopic(topic, incValue);
    }

    public void incBrokerGetNums(String topic, int incValue) {
        this.statsTable.get(BROKER_GET_NUMS).getAndCreateStatsItem(this.clusterName).getValue().add(incValue);
        this.incBrokerGetNumsWithoutSystemTopic(topic, incValue);
    }

    public void incBrokerAckNums(int incValue) {
        this.statsTable.get(BROKER_ACK_NUMS).getAndCreateStatsItem(this.clusterName).getValue().add(incValue);
    }

    public void incBrokerCkNums(int incValue) {
        this.statsTable.get(BROKER_CK_NUMS).getAndCreateStatsItem(this.clusterName).getValue().add(incValue);
    }

    public void incBrokerGetNumsWithoutSystemTopic(String topic, int incValue) {
        if (TopicValidator.isSystemTopic((String)topic)) {
            return;
        }
        this.statsTable.get(BROKER_GET_NUMS_WITHOUT_SYSTEM_TOPIC).getAndCreateStatsItem(this.clusterName).getValue().add(incValue);
    }

    public void incBrokerPutNumsWithoutSystemTopic(String topic, int incValue) {
        if (TopicValidator.isSystemTopic((String)topic)) {
            return;
        }
        this.statsTable.get(BROKER_PUT_NUMS_WITHOUT_SYSTEM_TOPIC).getAndCreateStatsItem(this.clusterName).getValue().add(incValue);
    }

    public long getBrokerGetNumsWithoutSystemTopic() {
        StatsItemSet statsItemSet = this.statsTable.get(BROKER_GET_NUMS_WITHOUT_SYSTEM_TOPIC);
        if (statsItemSet == null) {
            return 0L;
        }
        StatsItem statsItem = statsItemSet.getStatsItem(this.clusterName);
        if (statsItem == null) {
            return 0L;
        }
        return statsItem.getValue().longValue();
    }

    public long getBrokerPutNumsWithoutSystemTopic() {
        StatsItemSet statsItemSet = this.statsTable.get(BROKER_PUT_NUMS_WITHOUT_SYSTEM_TOPIC);
        if (statsItemSet == null) {
            return 0L;
        }
        StatsItem statsItem = statsItemSet.getStatsItem(this.clusterName);
        if (statsItem == null) {
            return 0L;
        }
        return statsItem.getValue().longValue();
    }

    public void incSendBackNums(String group, String topic) {
        String statsKey = this.buildStatsKey(topic, group);
        this.statsTable.get(SNDBCK_PUT_NUMS).addValue(statsKey, 1, 1);
    }

    public double tpsGroupGetNums(String group, String topic) {
        String statsKey = this.buildStatsKey(topic, group);
        return this.statsTable.get(GROUP_GET_NUMS).getStatsDataInMinute(statsKey).getTps();
    }

    public void recordDiskFallBehindTime(String group, String topic, int queueId, long fallBehind) {
        String statsKey = this.buildStatsKey(queueId, topic, group);
        this.momentStatsItemSetFallTime.getAndCreateStatsItem(statsKey).getValue().set(fallBehind);
    }

    public void recordDiskFallBehindSize(String group, String topic, int queueId, long fallBehind) {
        String statsKey = this.buildStatsKey(queueId, topic, group);
        this.momentStatsItemSetFallSize.getAndCreateStatsItem(statsKey).getValue().set(fallBehind);
    }

    public void incDLQStatValue(String key, String owner, String group, String topic, String type, int incValue) {
        String statsKey = this.buildCommercialStatsKey(owner, topic, group, type);
        this.statsTable.get(key).addValue(statsKey, incValue, 1);
    }

    public void incCommercialValue(String key, String owner, String group, String topic, String type, int incValue) {
        String statsKey = this.buildCommercialStatsKey(owner, topic, group, type);
        this.statsTable.get(key).addValue(statsKey, incValue, 1);
    }

    public void incAccountValue(String key, String accountOwnerParent, String accountOwnerSelf, String instanceId, String group, String topic, String msgType, int incValue) {
        String statsKey = this.buildAccountStatsKey(accountOwnerParent, accountOwnerSelf, instanceId, topic, group, msgType);
        this.statsTable.get(key).addValue(statsKey, incValue, 1);
    }

    public void incAccountValue(String key, String accountOwnerParent, String accountOwnerSelf, String instanceId, String group, String topic, String msgType, String flowlimitThreshold, int incValue) {
        String statsKey = this.buildAccountStatsKey(accountOwnerParent, accountOwnerSelf, instanceId, topic, group, msgType, flowlimitThreshold);
        this.statsTable.get(key).addValue(statsKey, incValue, 1);
    }

    public void incAccountValue(String statType, String owner, String instanceId, String topic, String group, String msgType, long ... incValues) {
        String key = this.buildAccountStatKey(owner, instanceId, topic, group, msgType);
        this.accountStatManager.inc(statType, key, incValues);
    }

    public void incAccountValue(String statType, String owner, String instanceId, String topic, String group, String msgType, String flowlimitThreshold, long ... incValues) {
        String key = this.buildAccountStatKey(owner, instanceId, topic, group, msgType, flowlimitThreshold);
        this.accountStatManager.inc(statType, key, incValues);
    }

    public String buildCommercialStatsKey(String owner, String topic, String group, String type) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(owner);
        strBuilder.append("@");
        strBuilder.append(topic);
        strBuilder.append("@");
        strBuilder.append(group);
        strBuilder.append("@");
        strBuilder.append(type);
        return strBuilder.toString();
    }

    public String buildAccountStatsKey(String accountOwnerParent, String accountOwnerSelf, String instanceId, String topic, String group, String msgType) {
        StringBuffer strBuilder = new StringBuffer();
        strBuilder.append(accountOwnerParent);
        strBuilder.append("@");
        strBuilder.append(accountOwnerSelf);
        strBuilder.append("@");
        strBuilder.append(instanceId);
        strBuilder.append("@");
        strBuilder.append(topic);
        strBuilder.append("@");
        strBuilder.append(group);
        strBuilder.append("@");
        strBuilder.append(msgType);
        return strBuilder.toString();
    }

    public String buildAccountStatsKey(String accountOwnerParent, String accountOwnerSelf, String instanceId, String topic, String group, String msgType, String flowlimitThreshold) {
        StringBuffer strBuilder = new StringBuffer();
        strBuilder.append(accountOwnerParent);
        strBuilder.append("@");
        strBuilder.append(accountOwnerSelf);
        strBuilder.append("@");
        strBuilder.append(instanceId);
        strBuilder.append("@");
        strBuilder.append(topic);
        strBuilder.append("@");
        strBuilder.append(group);
        strBuilder.append("@");
        strBuilder.append(msgType);
        strBuilder.append("@");
        strBuilder.append(flowlimitThreshold);
        return strBuilder.toString();
    }

    public String buildAccountStatKey(String owner, String instanceId, String topic, String group, String msgType) {
        String sep = "|";
        StringBuffer strBuilder = new StringBuffer();
        strBuilder.append(owner).append("|");
        strBuilder.append(instanceId).append("|");
        strBuilder.append(topic).append("|");
        strBuilder.append(group).append("|");
        strBuilder.append(msgType);
        return strBuilder.toString();
    }

    public String buildAccountStatKey(String owner, String instanceId, String topic, String group, String msgType, String flowlimitThreshold) {
        String sep = "|";
        StringBuffer strBuilder = new StringBuffer();
        strBuilder.append(owner).append("|");
        strBuilder.append(instanceId).append("|");
        strBuilder.append(topic).append("|");
        strBuilder.append(group).append("|");
        strBuilder.append(msgType).append("|");
        strBuilder.append(flowlimitThreshold);
        return strBuilder.toString();
    }

    public String[] splitAccountStatKey(String accountStatKey) {
        String sep = "\\|";
        return accountStatKey.split("\\|");
    }

    private StatisticsKindMeta createStatisticsKindMeta(String name, String[] itemNames, ScheduledExecutorService executorService, StatisticsItemFormatter formatter, Logger log, long interval) {
        final BrokerConfig brokerConfig = this.brokerConfig;
        StatisticsItemPrinter printer = new StatisticsItemPrinter(formatter, log);
        StatisticsKindMeta kindMeta = new StatisticsKindMeta();
        kindMeta.setName(name);
        kindMeta.setItemNames(itemNames);
        kindMeta.setScheduledPrinter((StatisticsItemScheduledPrinter)new StatisticsItemScheduledIncrementPrinter("Stat In One Minute: ", printer, executorService, new StatisticsItemScheduledPrinter.InitialDelay(){

            public long get() {
                return Math.abs(UtilAll.computeNextMinutesTimeMillis() - System.currentTimeMillis());
            }
        }, interval, new String[]{MSG_NUM}, new StatisticsItemScheduledPrinter.Valve(){

            public boolean enabled() {
                return brokerConfig != null ? brokerConfig.isAccountStatsEnable() : true;
            }

            public boolean printZeroLine() {
                return brokerConfig != null ? brokerConfig.isAccountStatsPrintZeroValues() : true;
            }
        }));
        return kindMeta;
    }

    public static enum StatsType {
        SEND_SUCCESS,
        SEND_FAILURE,
        RCV_SUCCESS,
        RCV_EPOLLS,
        SEND_BACK,
        SEND_BACK_TO_DLQ,
        SEND_ORDER,
        SEND_TIMER,
        SEND_TRANSACTION,
        PERM_FAILURE;

    }

    public static interface StateGetter {
        public boolean online(String var1, String var2, String var3);
    }
}

