/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

@ChannelHandler.Sharable
public class RemotingCodeDistributionHandler
extends ChannelDuplexHandler {
    private final ConcurrentMap<Integer, LongAdder> inboundDistribution = new ConcurrentHashMap<Integer, LongAdder>();
    private final ConcurrentMap<Integer, LongAdder> outboundDistribution = new ConcurrentHashMap<Integer, LongAdder>();

    private void countInbound(int requestCode) {
        LongAdder item = this.inboundDistribution.computeIfAbsent(requestCode, k -> new LongAdder());
        item.increment();
    }

    private void countOutbound(int responseCode) {
        LongAdder item = this.outboundDistribution.computeIfAbsent(responseCode, k -> new LongAdder());
        item.increment();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof RemotingCommand) {
            RemotingCommand cmd = (RemotingCommand)msg;
            this.countInbound(cmd.getCode());
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof RemotingCommand) {
            RemotingCommand cmd = (RemotingCommand)msg;
            this.countOutbound(cmd.getCode());
        }
        ctx.write(msg, promise);
    }

    private Map<Integer, Long> getDistributionSnapshot(Map<Integer, LongAdder> countMap) {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(countMap.size());
        for (Map.Entry<Integer, LongAdder> entry : countMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().sumThenReset());
        }
        return map;
    }

    private String snapshotToString(Map<Integer, Long> distribution) {
        if (null != distribution && !distribution.isEmpty()) {
            StringBuilder sb = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry<Integer, Long> entry : distribution.entrySet()) {
                if (0L == entry.getValue()) continue;
                sb.append(first ? "" : ", ").append(entry.getKey()).append(":").append(entry.getValue());
                first = false;
            }
            if (first) {
                return null;
            }
            sb.append("}");
            return sb.toString();
        }
        return null;
    }

    public String getInBoundSnapshotString() {
        return this.snapshotToString(this.getDistributionSnapshot(this.inboundDistribution));
    }

    public String getOutBoundSnapshotString() {
        return this.snapshotToString(this.getDistributionSnapshot(this.outboundDistribution));
    }
}

