/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage.zip;

import com.alipay.sofa.jraft.rhea.options.RheaKVStoreOptions;
import com.alipay.sofa.jraft.rhea.storage.zip.JDKZipStrategy;
import com.alipay.sofa.jraft.rhea.storage.zip.ParallelZipStrategy;
import com.alipay.sofa.jraft.rhea.storage.zip.ZipStrategy;

public final class ZipStrategyManager {
    private static ZipStrategy[] zipStrategies = new ZipStrategy[5];
    private static byte DEFAULT_STRATEGY = 1;
    public static final byte JDK_STRATEGY = 1;
    public static final byte PARALLEL_STRATEGY = 2;

    public static void addZipStrategy(int idx, ZipStrategy zipStrategy) {
        if (zipStrategies.length <= idx) {
            ZipStrategy[] newZipStrategies = new ZipStrategy[idx + 5];
            System.arraycopy(zipStrategies, 0, newZipStrategies, 0, zipStrategies.length);
            zipStrategies = newZipStrategies;
        }
        ZipStrategyManager.zipStrategies[idx] = zipStrategy;
    }

    public static ZipStrategy getZipStrategy(int idx) {
        return zipStrategies[idx];
    }

    public static ZipStrategy getDefault() {
        return zipStrategies[DEFAULT_STRATEGY];
    }

    public static void init(RheaKVStoreOptions opts) {
        if (opts.isUseParallelCompress() && zipStrategies[2] == null) {
            ParallelZipStrategy zipStrategy = new ParallelZipStrategy(opts.getCompressThreads(), opts.getDeCompressThreads());
            ZipStrategyManager.addZipStrategy(2, zipStrategy);
            DEFAULT_STRATEGY = (byte)2;
        }
    }

    private ZipStrategyManager() {
    }

    static {
        ZipStrategyManager.addZipStrategy(1, new JDKZipStrategy());
    }
}

