/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import org.apache.royale.compiler.common.IDefinitionPriority;

public final class DefinitionPriority
implements IDefinitionPriority {
    private final BasePriority basePriority;
    private long timestamp;
    private int order;

    public DefinitionPriority(BasePriority basePriority, long timestamp) {
        this(basePriority, timestamp, 0);
    }

    public DefinitionPriority(BasePriority basePriority, long timestamp, int order) {
        this.basePriority = basePriority;
        this.timestamp = timestamp;
        this.order = order;
    }

    public DefinitionPriority(BasePriority basePriority, DefinitionPriority other) {
        this.basePriority = basePriority;
        this.timestamp = other.timestamp;
        this.order = 0;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(IDefinitionPriority o) {
        DefinitionPriority other = (DefinitionPriority)o;
        int result = this.basePriority.priority - other.basePriority.priority;
        if (result != 0) {
            return result;
        }
        if (this.timestamp < other.timestamp) {
            return -1;
        }
        if (this.timestamp > other.timestamp) {
            return 1;
        }
        if (this.order < other.order) {
            return 1;
        }
        if (this.order > other.order) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.basePriority.name + "(" + String.valueOf(this.timestamp) + "," + String.valueOf(this.order) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefinitionPriority)) {
            return false;
        }
        DefinitionPriority other = (DefinitionPriority)obj;
        return this.basePriority == other.basePriority && this.timestamp == other.timestamp;
    }

    public BasePriority getBasePriority() {
        return this.basePriority;
    }

    public static enum BasePriority {
        SOURCE_LIST(-1, "SOURCE_LIST"),
        SOURCE_PATH(-2, "SOURCE_PATH"),
        CROSS_PROJECT_LIBRARY_PATH(-3, "LIBRARY_PATH"),
        LIBRARY_PATH(-4, "LIBRARY_PATH");

        public int priority;
        public final String name;

        private BasePriority(int p, String n2) {
            this.priority = p;
            this.name = n2;
        }
    }
}

