/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.caches;

import com.google.common.base.Joiner;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;

public abstract class ConcurrentCacheStoreBase<T> {
    private final ConcurrentMap<CacheStoreKeyBase, SoftReference<T>> cache = new ConcurrentHashMap<CacheStoreKeyBase, SoftReference<T>>();

    protected ConcurrentCacheStoreBase() {
    }

    public final T get(CacheStoreKeyBase key) {
        Object result = null;
        if (this.cache.containsKey(key)) {
            result = ((SoftReference)this.cache.get(key)).get();
        }
        if (result == null) {
            result = this.createEntryValue(key);
            if (result == null) {
                throw new NullPointerException("Null value not allowed in cache store.");
            }
            this.cache.put(key, new SoftReference<Object>(result));
        }
        assert (result != null) : "Expected non-null value from cache.";
        return result;
    }

    public final T remove(CacheStoreKeyBase key) {
        SoftReference entryRef = (SoftReference)this.cache.remove(key);
        if (entryRef == null) {
            return null;
        }
        return entryRef.get();
    }

    public int size() {
        return this.cache.size();
    }

    protected abstract T createEntryValue(CacheStoreKeyBase var1);

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" (").append(this.cache.size()).append(") {");
        result.append(Joiner.on((String)", ").join(this.cache.keySet()));
        result.append("} ");
        return result.toString();
    }
}

