/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.springframework.util.StringUtils;

public final class SwaggerUtils {
    private SwaggerUtils() {
    }

    public static String swaggerToString(Swagger swagger) {
        try {
            return Yaml.mapper().writeValueAsString((Object)swagger);
        }
        catch (Throwable e) {
            throw new ServiceCombException("Convert swagger to string failed, ", e);
        }
    }

    public static Swagger parseSwagger(URL url) {
        try {
            String swaggerContent = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return SwaggerUtils.internalParseSwagger(swaggerContent);
        }
        catch (Throwable e) {
            throw new ServiceCombException("Parse swagger from url failed, ", e);
        }
    }

    public static Swagger parseSwagger(String swaggerContent) {
        try {
            return SwaggerUtils.internalParseSwagger(swaggerContent);
        }
        catch (Throwable e) {
            throw new ServiceCombException("Parse swagger from content failed, ", e);
        }
    }

    public static void validateSwagger(Swagger swagger) {
        Map paths = swagger.getPaths();
        if (paths != null) {
            for (Path path : paths.values()) {
                Operation operation = path.getPost();
                if (operation == null) continue;
                List parameters = operation.getParameters();
                for (Parameter parameter : parameters) {
                    if (!BodyParameter.class.isInstance(parameter) || ((BodyParameter)parameter).getSchema() != null) continue;
                    throw new ServiceCombException("swagger validator: body parameter schema is empty.");
                }
            }
        }
    }

    private static Swagger internalParseSwagger(String swaggerContent) throws JsonParseException, JsonMappingException, IOException {
        Swagger swagger = (Swagger)Yaml.mapper().readValue(swaggerContent, Swagger.class);
        SwaggerUtils.correctResponses(swagger);
        return swagger;
    }

    public static void correctResponses(Operation operation) {
        int okCode = Response.Status.OK.getStatusCode();
        String strOkCode = String.valueOf(okCode);
        Response okResponse = null;
        for (Map.Entry responseEntry : operation.getResponses().entrySet()) {
            Response response = (Response)responseEntry.getValue();
            if (StringUtils.isEmpty((Object)response.getDescription())) {
                response.setDescription("response of " + (String)responseEntry.getKey());
            }
            if (operation.getResponses().get(strOkCode) != null) continue;
            int statusCode = NumberUtils.toInt((String)((String)responseEntry.getKey()));
            if ("default".equals(responseEntry.getKey())) {
                statusCode = okCode;
            }
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)statusCode))) continue;
            okResponse = response;
        }
        if (okResponse != null) {
            operation.addResponse(strOkCode, okResponse);
        }
    }

    public static void correctResponses(Swagger swagger) {
        if (swagger.getPaths() == null) {
            return;
        }
        for (Path path : swagger.getPaths().values()) {
            for (Operation operation : path.getOperations()) {
                SwaggerUtils.correctResponses(operation);
            }
        }
    }
}

