/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.description.field;

import java.lang.reflect.Field;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.assertj.core.internal.bytebuddy.description.ByteCodeElement;
import org.assertj.core.internal.bytebuddy.description.ModifierReviewable;
import org.assertj.core.internal.bytebuddy.description.NamedElement;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationDescription;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationList;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeVariableToken;
import org.assertj.core.internal.bytebuddy.jar.asm.signature.SignatureWriter;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

public interface FieldDescription
extends ByteCodeElement,
ModifierReviewable.ForFieldDescription,
NamedElement.WithGenericName,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final Object NO_DEFAULT_VALUE = null;

    public TypeDescription.Generic getType();

    public int getActualModifiers();

    public SignatureToken asSignatureToken();

    public static class SignatureToken {
        private final String name;
        private final TypeDescription type;

        public SignatureToken(String name, TypeDescription type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription getType() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignatureToken)) {
                return false;
            }
            SignatureToken signatureToken = (SignatureToken)other;
            return this.name.equals(signatureToken.name) && this.type.equals(signatureToken.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return this.type + " " + this.name;
        }
    }

    public static class Token
    implements ByteCodeElement.Token<Token> {
        private final String name;
        private final int modifiers;
        private final TypeDescription.Generic type;
        private final List<? extends AnnotationDescription> annotations;

        public Token(String name, int modifiers, TypeDescription.Generic type) {
            this(name, modifiers, type, Collections.emptyList());
        }

        public Token(String name, int modifiers, TypeDescription.Generic type, List<? extends AnnotationDescription> annotations) {
            this.name = name;
            this.modifiers = modifiers;
            this.type = type;
            this.annotations = annotations;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription.Generic getType() {
            return this.type;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        @Override
        public Token accept(TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            return new Token(this.name, this.modifiers, this.type.accept(visitor), this.annotations);
        }

        public SignatureToken asSignatureToken(TypeDescription declaringType) {
            return new SignatureToken(this.name, this.type.accept(new TypeDescription.Generic.Visitor.Reducing(declaringType, new TypeVariableToken[0])));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Token token = (Token)other;
            return this.modifiers == token.modifiers && this.name.equals(token.name) && this.type.equals(token.type) && this.annotations.equals(token.annotations);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.modifiers;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.annotations.hashCode();
            return result;
        }
    }

    public static class TypeSubstituting
    extends AbstractBase
    implements InGenericShape {
        private final TypeDescription.Generic declaringType;
        private final FieldDescription fieldDescription;
        private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

        public TypeSubstituting(TypeDescription.Generic declaringType, FieldDescription fieldDescription, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            this.declaringType = declaringType;
            this.fieldDescription = fieldDescription;
            this.visitor = visitor;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.fieldDescription.getType().accept(this.visitor);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.fieldDescription.getDeclaredAnnotations();
        }

        @Override
        public TypeDescription.Generic getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.fieldDescription.getModifiers();
        }

        @Override
        public String getName() {
            return this.fieldDescription.getName();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.fieldDescription.asDefined();
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final TypeDescription declaringType;
        private final String fieldName;
        private final int modifiers;
        private final TypeDescription.Generic fieldType;
        private final List<? extends AnnotationDescription> declaredAnnotations;

        public Latent(TypeDescription declaringType, Token token) {
            this(declaringType, token.getName(), token.getModifiers(), token.getType(), token.getAnnotations());
        }

        public Latent(TypeDescription declaringType, String fieldName, int modifiers, TypeDescription.Generic fieldType, List<? extends AnnotationDescription> declaredAnnotations) {
            this.declaringType = declaringType;
            this.fieldName = fieldName;
            this.modifiers = modifiers;
            this.fieldType = fieldType;
            this.declaredAnnotations = declaredAnnotations;
        }

        @Override
        public TypeDescription.Generic getType() {
            return this.fieldType.accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }

        @Override
        public String getName() {
            return this.fieldName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }
    }

    public static class ForLoadedField
    extends InDefinedShape.AbstractBase {
        private final Field field;

        public ForLoadedField(Field field) {
            this.field = field;
        }

        @Override
        public TypeDescription.Generic getType() {
            if (TypeDescription.AbstractBase.RAW_TYPES) {
                return TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(this.field.getType());
            }
            return new TypeDescription.Generic.LazyProjection.ForLoadedFieldType(this.field);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.field.getDeclaredAnnotations());
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return TypeDescription.ForLoadedType.of(this.field.getDeclaringClass());
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.field.isSynthetic();
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements FieldDescription {
        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public String getActualName() {
            return this.getName();
        }

        @Override
        public String getDescriptor() {
            return this.getType().asErasure().getDescriptor();
        }

        @Override
        public String getGenericSignature() {
            TypeDescription.Generic fieldType = this.getType();
            try {
                return fieldType.getSort().isNonGeneric() ? NON_GENERIC_SIGNATURE : fieldType.accept(new TypeDescription.Generic.Visitor.ForSignatureVisitor(new SignatureWriter())).toString();
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.getDeclaringType().asErasure().isVisibleTo(typeDescription) && (this.isPublic() || typeDescription.equals(this.getDeclaringType().asErasure()) || this.isProtected() && this.getDeclaringType().asErasure().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType().asErasure()));
        }

        @Override
        public boolean isAccessibleTo(TypeDescription typeDescription) {
            return this.isPublic() || typeDescription.equals(this.getDeclaringType().asErasure()) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType().asErasure());
        }

        @Override
        public int getActualModifiers() {
            return this.getModifiers() | (this.getDeclaredAnnotations().isAnnotationPresent(Deprecated.class) ? 131072 : 0);
        }

        @Override
        public Token asToken(ElementMatcher<? super TypeDescription> matcher) {
            return new Token(this.getName(), this.getModifiers(), this.getType().accept(new TypeDescription.Generic.Visitor.Substitutor.ForDetachment(matcher)), this.getDeclaredAnnotations());
        }

        @Override
        public SignatureToken asSignatureToken() {
            return new SignatureToken(this.getInternalName(), this.getType().asErasure());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldDescription)) {
                return false;
            }
            FieldDescription fieldDescription = (FieldDescription)other;
            return this.getName().equals(fieldDescription.getName()) && this.getDeclaringType().equals(fieldDescription.getDeclaringType());
        }

        public int hashCode() {
            return this.getDeclaringType().hashCode() + 31 * (17 + this.getName().hashCode());
        }

        @Override
        public String toGenericString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getModifiers() != 0) {
                stringBuilder.append(Modifier.toString(this.getModifiers())).append(' ');
            }
            stringBuilder.append(this.getType().getActualName()).append(' ');
            stringBuilder.append(this.getDeclaringType().asErasure().getActualName()).append('.');
            return stringBuilder.append(this.getName()).toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getModifiers() != 0) {
                stringBuilder.append(Modifier.toString(this.getModifiers())).append(' ');
            }
            stringBuilder.append(this.getType().asErasure().getActualName()).append(' ');
            stringBuilder.append(this.getDeclaringType().asErasure().getActualName()).append('.');
            return stringBuilder.append(this.getName()).toString();
        }
    }

    public static interface InDefinedShape
    extends FieldDescription {
        @Override
        public TypeDescription getDeclaringType();

        public static abstract class AbstractBase
        extends org.assertj.core.internal.bytebuddy.description.field.FieldDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }
        }
    }

    public static interface InGenericShape
    extends FieldDescription {
        @Override
        public TypeDescription.Generic getDeclaringType();
    }
}

